/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.task.modules.services.impl;

import cn.wizzer.app.task.modules.services.TaskPlatformService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.nutz.integration.quartz.QuartzJob;
import org.nutz.integration.quartz.QuartzManager;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.quartz.JobKey;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

@IocBean
public class TaskPlatformServiceImpl
implements TaskPlatformService {
    @Inject
    private QuartzManager quartzManager;

    @Override
    public boolean isExist(String jobName, String jobGroup) {
        return this.quartzManager.exist(new JobKey(jobName, jobGroup));
    }

    @Override
    public void add(String jobName, String jobGroup, String className, String cron, String comment, String dataMap) {
        QuartzJob qj = new QuartzJob();
        qj.setJobName(jobName);
        qj.setJobGroup(jobGroup);
        qj.setClassName(className);
        qj.setCron(cron);
        qj.setComment(comment);
        qj.setDataMap(dataMap);
        this.quartzManager.add(qj);
    }

    @Override
    public boolean delete(String jobName, String jobGroup) {
        QuartzJob qj = new QuartzJob();
        qj.setJobName(jobName);
        qj.setJobGroup(jobGroup);
        return this.quartzManager.delete(qj);
    }

    @Override
    public void clear() {
        this.quartzManager.clear();
    }

    @Override
    public List<String> getCronExeTimes(String cronExpression) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression(cronExpression);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(2, 1);
        List dates = TriggerUtils.computeFireTimesBetween((OperableTrigger)cronTriggerImpl, null, (Date)now, (Date)calendar.getTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < dates.size() && i <= 4; ++i) {
            list.add(dateFormat.format((Date)dates.get(i)));
        }
        return list;
    }
}

