/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.handler;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class WkErrorPageHandler
extends ErrorPageErrorHandler {
    private static final Log log = Logs.get();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.getStatus() == 403 || response.getStatus() == 404 || response.getStatus() == 500) {
            try {
                if (this.isAjax((ServletRequest)request)) {
                    response.getWriter().write(Json.toJson((Object)new NutMap("code", (Object)"-1").setv("msg", (Object)(response.getStatus() + " error"))));
                    return;
                }
                request.setAttribute("original_request_uri", (Object)request.getRequestURI());
                RequestDispatcher rd = request.getRequestDispatcher("/platform/home/" + response.getStatus());
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (ServletException e) {
                log.error((Object)e);
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    private boolean isAjax(ServletRequest req) {
        String value = ((HttpServletRequest)req).getHeader("X-Requested-With");
        return value != null && "XMLHttpRequest".equalsIgnoreCase(value.trim());
    }
}

