/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.ext.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_msg;
import cn.wizzer.app.wx.modules.models.Wx_reply;
import cn.wizzer.app.wx.modules.models.Wx_reply_img;
import cn.wizzer.app.wx.modules.models.Wx_reply_news;
import cn.wizzer.app.wx.modules.models.Wx_reply_txt;
import cn.wizzer.app.wx.modules.models.Wx_user;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxMsgService;
import cn.wizzer.app.wx.modules.services.WxReplyImgService;
import cn.wizzer.app.wx.modules.services.WxReplyNewsService;
import cn.wizzer.app.wx.modules.services.WxReplyService;
import cn.wizzer.app.wx.modules.services.WxReplyTxtService;
import cn.wizzer.app.wx.modules.services.WxUserService;
import com.vdurmont.emoji.EmojiParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.weixin.bean.WxArticle;
import org.nutz.weixin.bean.WxInMsg;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.impl.AbstractWxHandler;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.AesException;
import org.nutz.weixin.repo.com.qq.weixin.mp.aes.WXBizMsgCrypt;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;
import org.nutz.weixin.util.Wxs;

@IocBean(name="wxHandler")
public class WxHandler
extends AbstractWxHandler {
    private static final Log log = Logs.get();
    protected String token;
    protected String aeskey;
    protected WXBizMsgCrypt msgCrypt;
    protected String appid;
    protected WxApi2 api;
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private WxUserService wxUserService;
    @Inject
    private WxReplyService wxReplyService;
    @Inject
    private WxReplyNewsService wxReplyNewsService;
    @Inject
    private WxReplyTxtService wxReplyTxtService;
    @Inject
    private WxReplyImgService wxReplyImgService;
    @Inject
    private WxMsgService wxMsgService;
    @Inject
    private WxService wxService;

    public boolean check(String signature, String timestamp, String nonce, String key) {
        Wx_config appInfo = (Wx_config)this.wxConfigService.fetch((Condition)Cnd.where((String)"id", (String)"=", (Object)key));
        if (appInfo != null) {
            this.token = appInfo.getToken();
            this.aeskey = appInfo.getEncodingAESKey();
            this.appid = appInfo.getAppid();
            return Wxs.check((String)appInfo.getToken(), (String)signature, (String)timestamp, (String)nonce);
        }
        return false;
    }

    public WXBizMsgCrypt getMsgCrypt() {
        if (this.msgCrypt == null) {
            try {
                this.msgCrypt = new WXBizMsgCrypt(this.token, this.aeskey, this.appid);
            }
            catch (AesException var2) {
                throw new RuntimeException(var2);
            }
        }
        return this.msgCrypt;
    }

    public WxOutMsg text(WxInMsg msg) {
        Wx_reply reply = (Wx_reply)this.wxReplyService.fetch((Condition)Cnd.where((String)"wxid", (String)"=", (Object)msg.getExtkey()).and("type", "=", (Object)"keyword").and("keyword", "=", (Object)msg.getContent()));
        if (reply != null) {
            if ("txt".equals(reply.getMsgType())) {
                String txtId = reply.getContent();
                Wx_reply_txt txt = (Wx_reply_txt)this.wxReplyTxtService.fetch(txtId);
                return Wxs.respText(null, (String)(txt == null ? "" : txt.getContent()));
            }
            if ("image".equals(reply.getMsgType())) {
                String imgId = reply.getContent();
                Wx_reply_img img = (Wx_reply_img)this.wxReplyImgService.fetch(imgId);
                return Wxs.respImage(null, (String)img.getMediaId());
            }
            if ("news".equals(reply.getMsgType())) {
                String[] newsIds = StringUtils.split((String)Strings.sNull((Object)reply.getContent()), (String)",");
                ArrayList<WxArticle> list = new ArrayList<WxArticle>();
                List newsList = this.wxReplyNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)newsIds).asc("location"));
                for (Wx_reply_news news : newsList) {
                    WxArticle wxArticle = new WxArticle();
                    wxArticle.setDescription(news.getDescription());
                    wxArticle.setPicUrl(news.getPicUrl());
                    wxArticle.setTitle(news.getTitle());
                    wxArticle.setUrl(news.getUrl());
                    list.add(wxArticle);
                }
                return Wxs.respNews(null, list);
            }
        }
        Wx_user usr = (Wx_user)this.wxUserService.fetch((Condition)Cnd.where((String)"openid", (String)"=", (Object)msg.getFromUserName()));
        Wx_msg wxMsg = new Wx_msg();
        wxMsg.setOpenid(msg.getFromUserName());
        wxMsg.setContent(EmojiParser.parseToAliases((String)msg.getContent(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
        wxMsg.setWxid(msg.getExtkey());
        wxMsg.setType("txt");
        wxMsg.setNickname(usr == null ? "\u533f\u540d" : usr.getNickname());
        wxMsg.setDelFlag(false);
        this.wxMsgService.insert(wxMsg);
        return Wxs.respText(null, (String)"\u60a8\u7684\u7559\u8a00\u5df2\u6536\u5230\uff01");
    }

    public WxOutMsg eventClick(WxInMsg msg) {
        String eventKey = msg.getEventKey();
        log.debug((Object)("eventKey: " + eventKey));
        log.debug((Object)("extKey: " + msg.getExtkey()));
        Wx_reply reply = (Wx_reply)this.wxReplyService.fetch((Condition)Cnd.where((String)"type", (String)"=", (Object)"keyword").and("wxid", "=", (Object)msg.getExtkey()).and("keyword", "=", (Object)eventKey));
        if (reply != null) {
            if ("txt".equals(reply.getMsgType())) {
                String txtId = reply.getContent();
                Wx_reply_txt txt = (Wx_reply_txt)this.wxReplyTxtService.fetch(txtId);
                return Wxs.respText(null, (String)(txt == null ? "" : txt.getContent()));
            }
            if ("image".equals(reply.getMsgType())) {
                String imgId = reply.getContent();
                Wx_reply_img img = (Wx_reply_img)this.wxReplyImgService.fetch(imgId);
                return Wxs.respImage(null, (String)img.getMediaId());
            }
            if ("news".equals(reply.getMsgType())) {
                String[] newsIds = StringUtils.split((String)Strings.sNull((Object)reply.getContent()), (String)",");
                ArrayList<WxArticle> list = new ArrayList<WxArticle>();
                List newsList = this.wxReplyNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)newsIds).asc("location"));
                for (Wx_reply_news news : newsList) {
                    WxArticle wxArticle = new WxArticle();
                    wxArticle.setDescription(news.getDescription());
                    wxArticle.setPicUrl(news.getPicUrl());
                    wxArticle.setTitle(news.getTitle());
                    wxArticle.setUrl(news.getUrl());
                    list.add(wxArticle);
                }
                return Wxs.respNews(null, list);
            }
        }
        return this.defaultMsg(msg);
    }

    public WxOutMsg eventSubscribe(WxInMsg msg) {
        if (this.api == null) {
            this.api = this.wxService.getWxApi2(msg.getExtkey());
        }
        Wx_user usr = (Wx_user)this.wxUserService.fetch((Condition)Cnd.where((String)"openid", (String)"=", (Object)msg.getFromUserName()));
        WxResp resp = this.api.user_info(msg.getFromUserName(), "zh_CN");
        if (usr == null) {
            usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
            usr.setNickname(EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
            usr.setSubscribeAt(Times.getTS());
            usr.setWxid(msg.getExtkey());
            this.wxUserService.insert(usr);
        } else {
            String id = usr.getId();
            usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
            usr.setNickname(EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
            usr.setOpAt(Times.getTS());
            usr.setWxid(msg.getExtkey());
            usr.setId(id);
            this.wxUserService.updateIgnoreNull(usr);
        }
        Wx_reply reply = (Wx_reply)this.wxReplyService.fetch((Condition)Cnd.where((String)"wxid", (String)"=", (Object)msg.getExtkey()).and("type", "=", (Object)"follow"));
        if (reply != null) {
            if ("txt".equals(reply.getMsgType())) {
                String txtId = reply.getContent();
                Wx_reply_txt txt = (Wx_reply_txt)this.wxReplyTxtService.fetch(txtId);
                return Wxs.respText(null, (String)(txt == null ? "" : txt.getContent()));
            }
            if ("image".equals(reply.getMsgType())) {
                String imgId = reply.getContent();
                Wx_reply_img img = (Wx_reply_img)this.wxReplyImgService.fetch(imgId);
                return Wxs.respImage(null, (String)img.getMediaId());
            }
            if ("news".equals(reply.getMsgType())) {
                String[] newsIds = Strings.sBlank((Object)reply.getContent()).split(",");
                ArrayList<WxArticle> list = new ArrayList<WxArticle>();
                List newsList = this.wxReplyNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)newsIds).asc("location"));
                for (Wx_reply_news news : newsList) {
                    WxArticle wxArticle = new WxArticle();
                    wxArticle.setDescription(news.getDescription());
                    wxArticle.setPicUrl(news.getPicUrl());
                    wxArticle.setTitle(news.getTitle());
                    wxArticle.setUrl(news.getUrl());
                    list.add(wxArticle);
                }
                return Wxs.respNews(null, list);
            }
        }
        return Wxs.respText(null, (String)"\u8c22\u8c22\u60a8\u7684\u5173\u6ce8\uff01");
    }

    public WxOutMsg eventUnsubscribe(WxInMsg msg) {
        Wx_user usr = (Wx_user)this.wxUserService.fetch((Condition)Cnd.where((String)"openid", (String)"=", (Object)msg.getFromUserName()));
        if (usr != null) {
            this.wxUserService.update(Chain.make((String)"subscribe", (Object)false).add("opAt", (Object)Times.getTS()), (Condition)Cnd.where((String)"openid", (String)"=", (Object)msg.getFromUserName()));
        }
        return super.eventUnsubscribe(msg);
    }

    public WxOutMsg defaultMsg(WxInMsg msg) {
        return Wxs.respText((String)("\u8fd9\u662f\u7f3a\u7701\u56de\u590d\u54e6.\u4f60\u53d1\u9001\u7684\u7c7b\u578b\u662f:" + msg.getMsgType()));
    }
}

