/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.commons.shiro.realm;

import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysRoleService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.shiro.exception.CaptchaEmptyException;
import cn.wizzer.app.web.commons.shiro.exception.CaptchaIncorrectException;
import cn.wizzer.app.web.commons.shiro.token.PlatformCaptchaToken;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.nutz.castor.Castors;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean(name="platformRealm")
public class PlatformAuthorizingRealm
extends AuthorizingRealm {
    private static final Log log = Logs.get();
    @Inject
    private SysUserService sysUserService;
    @Inject
    private SysRoleService sysRoleService;
    @Inject
    private RedisService redisService;

    protected SysUserService getUserService() {
        return this.sysUserService;
    }

    protected SysRoleService getRoleService() {
        return this.sysRoleService;
    }

    protected RedisService getRedisService() {
        return this.redisService;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (token.getClass().isAssignableFrom(PlatformCaptchaToken.class)) {
            Sys_user user;
            PlatformCaptchaToken authcToken = (PlatformCaptchaToken)token;
            String loginname = authcToken.getUsername();
            String captcha = authcToken.getCaptcha();
            if (Strings.isBlank((CharSequence)loginname)) {
                throw (AuthenticationException)Lang.makeThrow(AuthenticationException.class, (String)"Account name is empty", (Object[])new Object[0]);
            }
            Session session = SecurityUtils.getSubject().getSession(true);
            int errCount = NumberUtils.toInt((String)Strings.sNull((Object)session.getAttribute((Object)"platformErrCount")));
            if (errCount > 2) {
                if (Strings.isBlank((CharSequence)captcha)) {
                    throw (CaptchaEmptyException)((Object)Lang.makeThrow(CaptchaEmptyException.class, (String)"Captcha is empty", (Object[])new Object[0]));
                }
                String _captcha = this.getRedisService().get("platformCaptcha:" + session.getId());
                if (!authcToken.getCaptcha().equalsIgnoreCase(_captcha)) {
                    throw (CaptchaIncorrectException)((Object)Lang.makeThrow(CaptchaIncorrectException.class, (String)"Captcha is error", (Object[])new Object[0]));
                }
            }
            if (Lang.isEmpty((Object)(user = (Sys_user)this.getUserService().fetch((Condition)Cnd.where((String)"loginname", (String)"=", (Object)loginname))))) {
                throw (UnknownAccountException)Lang.makeThrow(UnknownAccountException.class, (String)"Account [ %s ] not found", (Object[])new Object[]{loginname});
            }
            if (user.isDisabled()) {
                throw (LockedAccountException)Lang.makeThrow(LockedAccountException.class, (String)"Account [ %s ] is locked.", (Object[])new Object[]{loginname});
            }
            user = (Sys_user)this.getUserService().fetchLinks(user, null);
            user = this.getUserService().fillMenu(user);
            session.setAttribute((Object)"platformErrCount", (Object)0);
            session.setAttribute((Object)"platform_uid", (Object)user.getId());
            session.setAttribute((Object)"platform_username", (Object)user.getUsername());
            session.setAttribute((Object)"platform_loginname", (Object)user.getLoginname());
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user, (Object)user.getPassword().toCharArray(), ByteSource.Util.bytes((String)user.getSalt()), this.getName());
            info.setCredentialsSalt(ByteSource.Util.bytes((String)user.getSalt()));
            return info;
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Object object = principals.getPrimaryPrincipal();
        if (object.getClass().isAssignableFrom(Sys_user.class)) {
            Sys_user user = (Sys_user)Castors.me().castTo(object, Sys_user.class);
            if (!Lang.isEmpty((Object)user) && !user.isDisabled()) {
                SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
                info.addRoles(this.getUserService().getRoleCodeList(user));
                for (Sys_role role : user.getRoles()) {
                    if (role.isDisabled()) continue;
                    info.addStringPermissions(this.getRoleService().getPermissionNameList(role));
                }
                return info;
            }
            return null;
        }
        return null;
    }

    public PlatformAuthorizingRealm() {
        this(null, null);
    }

    public PlatformAuthorizingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        super(cacheManager, matcher);
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher();
        hashedCredentialsMatcher.setHashAlgorithmName("SHA-256");
        hashedCredentialsMatcher.setHashIterations(1024);
        hashedCredentialsMatcher.setStoredCredentialsHexEncoded(true);
        this.setAuthenticationTokenClass(PlatformCaptchaToken.class);
        this.setCredentialsMatcher((CredentialsMatcher)hashedCredentialsMatcher);
    }

    public PlatformAuthorizingRealm(CacheManager cacheManager) {
        this(cacheManager, null);
    }

    public PlatformAuthorizingRealm(CredentialsMatcher matcher) {
        this(null, matcher);
    }
}

