/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.open.api;

import cn.wizzer.app.sys.modules.models.Sys_app_conf;
import cn.wizzer.app.sys.modules.models.Sys_app_list;
import cn.wizzer.app.sys.modules.models.Sys_app_task;
import cn.wizzer.app.sys.modules.services.SysAppConfService;
import cn.wizzer.app.sys.modules.services.SysAppListService;
import cn.wizzer.app.sys.modules.services.SysAppTaskService;
import cn.wizzer.app.web.commons.filter.ApiDeploySignFilter;
import cn.wizzer.framework.base.Result;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.nutz.boot.starter.ftp.FtpService;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Streams;
import org.nutz.lang.Times;
import org.nutz.lang.stream.StringInputStream;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.By;
import org.nutz.mvc.annotation.Filters;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/open/api/deploy"})
@Filters(value={@By(type=ApiDeploySignFilter.class)})
public class ApiDeployController {
    private static final Log log = Logs.get();
    @Inject
    private SysAppTaskService sysAppTaskService;
    @Inject
    private SysAppListService sysAppListService;
    @Inject
    private SysAppConfService sysAppConfService;
    @Inject
    private FtpService ftpService;
    @Inject
    private RedisService redisService;
    @Inject
    private PropertiesProxy conf;

    @At(value={"/task"})
    @Ok(value="json")
    @POST
    public Object task(@Param(value="apps") String[] apps, @Param(value="hostname") String hostname, @Param(value="timestamp") long timestamp, @Param(value="mem_total") long mem_total, @Param(value="mem_used") long mem_used, @Param(value="mem_free") long mem_free, @Param(value="mem_percent") double mem_percent, @Param(value="cpu_percent") double cpu_percent, @Param(value="net_sent") long net_sent, @Param(value="net_recv") long net_recv, @Param(value="net_tcp") long net_tcp, @Param(value="hdd_total") long hdd_total, @Param(value="hdd_used") long hdd_used, @Param(value="hdd_free") long hdd_free, @Param(value="hdd_percent") double hdd_percent) {
        try {
            List list = this.sysAppTaskService.query((Condition)Cnd.where((String)"name", (String)"in", (Object)apps).and("hostName", "=", (Object)hostname).and("status", "=", (Object)0));
            ArrayList<String> ids = new ArrayList<String>();
            for (Sys_app_task task : list) {
                ids.add(task.getId());
            }
            this.sysAppTaskService.update(Chain.make((String)"status", (Object)1), (Condition)Cnd.where((String)"id", (String)"in", ids));
            long now3 = Times.getTS() - 180L;
            this.sysAppTaskService.update(Chain.make((String)"status", (Object)3).add("pushAt", (Object)Times.getTS()).add("pushResult", (Object)"\u4efb\u52a1\u8d85\u65f6"), (Condition)Cnd.where((String)"name", (String)"in", (Object)apps).and("hostName", "=", (Object)hostname).and("status", "=", (Object)1).and("opAt", "<", (Object)now3));
            NutMap map = NutMap.NEW().addv("mem_total", (Object)mem_total).addv("mem_used", (Object)mem_used).addv("mem_free", (Object)mem_free).addv("mem_percent", (Object)mem_percent).addv("cpu_percent", (Object)cpu_percent).addv("net_sent", (Object)net_sent).addv("net_recv", (Object)net_recv).addv("net_tcp", (Object)net_tcp).addv("hdd_total", (Object)hdd_total).addv("hdd_used", (Object)hdd_used).addv("hdd_free", (Object)hdd_free).addv("hdd_percent", (Object)hdd_percent).addv("timestamp", (Object)timestamp);
            this.redisService.setex("logback:deploy:" + hostname + ":" + timestamp, 600, Json.toJson((Object)map, (JsonFormat)JsonFormat.compact()));
            return Result.success((String)"\u83b7\u53d6\u6210\u529f").addData((Object)list);
        }
        catch (Exception e) {
            return Result.error((String)"\u83b7\u53d6\u5931\u8d25");
        }
    }

    @At(value={"/report"})
    @Ok(value="json")
    @POST
    public Object report(@Param(value="hostname") String hostname, @Param(value="taskid") String taskid, @Param(value="status") int status, @Param(value="msg") String msg) {
        try {
            this.sysAppTaskService.update(Chain.make((String)"status", (Object)status).add("pushResult", (Object)msg).add("pushAt", (Object)Times.getTS()), (Condition)Cnd.where((String)"id", (String)"=", (Object)taskid));
            return Result.success((String)"\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            return Result.error((String)"\u6267\u884c\u5931\u8d25");
        }
    }

    @At(value={"/jar/download"})
    @Ok(value="void")
    public void jarDownload(@Param(value="name") String name, @Param(value="version") String version, HttpServletResponse response) {
        block15: {
            try {
                Sys_app_list sysAppList = (Sys_app_list)this.sysAppListService.fetch((Condition)Cnd.where((String)"appName", (String)"=", (Object)name).and("appVersion", "=", (Object)version).and("disabled", "=", (Object)false));
                if (sysAppList == null) break block15;
                String fileName = sysAppList.getAppName() + ".jar";
                response.setHeader("Content-Type", "application/java-archive");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                response.setContentLengthLong(sysAppList.getFileSize().longValue());
                if (this.conf.getBoolean("ftp.enabled")) {
                    this.ftpService.download(sysAppList.getFilePath(), (OutputStream)response.getOutputStream());
                    break block15;
                }
                String staticPath = this.conf.get("jetty.staticPath", "/files");
                try (FileInputStream in = new FileInputStream(new File(staticPath + sysAppList.getFilePath()));){
                    Streams.writeAndClose((OutputStream)response.getOutputStream(), (InputStream)in);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @At(value={"/conf/download"})
    @Ok(value="void")
    public void confDownload(@Param(value="name") String name, @Param(value="version") String version, HttpServletResponse response) {
        block14: {
            try {
                Sys_app_conf conf = (Sys_app_conf)this.sysAppConfService.fetch((Condition)Cnd.where((String)"confName", (String)"=", (Object)name).and("confVersion", "=", (Object)version).and("disabled", "=", (Object)false));
                if (conf == null) break block14;
                String fileName = conf.getConfName() + "-" + conf.getConfVersion() + ".properties";
                response.setHeader("Content-Type", "text/plain");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                try (StringInputStream in = new StringInputStream((CharSequence)conf.getConfData());){
                    Streams.writeAndClose((OutputStream)response.getOutputStream(), (InputStream)in);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

