/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.cms;

import cn.wizzer.app.cms.modules.models.Cms_site;
import cn.wizzer.app.cms.modules.services.CmsSiteService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.adaptor.WhaleAdaptor;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/cms/site"})
public class CmsSiteController {
    private static final Log log = Logs.get();
    @Inject
    private CmsSiteService cmsSiteService;

    @At(value={""})
    @Ok(value="beetl:/platform/cms/site/index.html")
    @RequiresPermissions(value={"cms.site.settings"})
    public Object index() {
        Cms_site site = (Cms_site)this.cmsSiteService.fetch("site");
        if (site == null) {
            site = new Cms_site();
            site.setId("site");
            site.setSite_name("Demo");
            site.setSite_domain("https://wizzer.cn");
            this.cmsSiteService.insert(site);
        }
        return site;
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.content.article"})
    public Object data(@Param(value="siteName") String siteName, @Param(value="siteDomain") String siteDomain, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.where((String)"delFlag", (String)"=", (Object)false);
        if (Strings.isNotBlank((CharSequence)siteName)) {
            cnd.and("site_name", "like", (Object)("%" + siteName + "%"));
        }
        if (Strings.isNotBlank((CharSequence)siteDomain)) {
            cnd.and("site_domain", "like", (Object)("%" + siteDomain + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.cmsSiteService.listPage(pageNumber, pageSize, (Condition)cnd));
    }

    @At(value={"/add"})
    @Ok(value="beetl:/platform/cms/site/add.html")
    @RequiresPermissions(value={"cms.site.settings"})
    public void add() {
    }

    @At(value={"/edit/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"cms.site.settings"})
    public Object edit(String id) {
        try {
            return Result.success((String)"system.success", (Object)this.cmsSiteService.fetch(id));
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.site.settings.save"})
    @SLog(tag="\u6dfb\u52a0\u7ad9\u70b9", msg="${args[0].site_name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object addDo(@Param(value="..") Cms_site site) {
        try {
            site.setOpAt(Times.getTS());
            site.setOpBy(StringUtil.getPlatformUid());
            this.cmsSiteService.insert(site);
            this.cmsSiteService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"cms.site.settings.save"})
    @SLog(tag="\u4fee\u6539\u7ad9\u70b9", msg="${args[0].site_name}")
    @AdaptBy(type=WhaleAdaptor.class)
    public Object editDo(@Param(value="..") Cms_site site) {
        try {
            site.setOpAt(Times.getTS());
            site.setOpBy(StringUtil.getPlatformUid());
            this.cmsSiteService.updateIgnoreNull(site);
            this.cmsSiteService.clearCache();
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.delete"})
    @SLog(tag="\u5220\u9664\u7ad9\u70b9", msg="\u7ad9\u70b9:${args[0]}")
    public Object delete(String id) {
        try {
            this.cmsSiteService.delete(id);
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }
}

