/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.services.SysApiService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/api"})
public class SysApiController {
    private static final Log log = Logs.get();
    @Inject
    private SysApiService sysApiService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/api/index.html")
    @RequiresPermissions(value={"sys.manager.api"})
    public void index() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.api.add"})
    @SLog(tag="\u65b0\u5efa\u5bc6\u94a5", msg="\u5e94\u7528\u540d\u79f0:${name}")
    public Object addDo(@Param(value="name") String name, HttpServletRequest req) {
        try {
            this.sysApiService.createAppkey(name, StringUtil.getPlatformUid());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.api.delete"})
    @SLog(tag="\u5220\u9664\u5bc6\u94a5", msg="Appid:${appid}")
    public Object delete(String appid, HttpServletRequest req) {
        try {
            this.sysApiService.deleteAppkey(appid);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.api.edit"})
    @SLog(tag="\u542f\u7528\u5bc6\u94a5", msg="Appid:${appid}")
    public Object enable(String appid, HttpServletRequest req) {
        try {
            this.sysApiService.updateAppkey(appid, false);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.api.edit"})
    @SLog(tag="\u7981\u7528\u5bc6\u94a5", msg="Appid:${appid}")
    public Object disable(String appid, HttpServletRequest req) {
        try {
            this.sysApiService.updateAppkey(appid, true);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.api"})
    public Object data(@Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysApiService.listPage(pageNumber, pageSize, (Condition)cnd));
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

