/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_config;
import cn.wizzer.app.sys.modules.services.SysConfigService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/conf"})
public class SysConfController {
    private static final Log log = Logs.get();
    @Inject
    private SysConfigService sysConfigService;
    @Inject
    private PubSubService pubSubService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/conf/index.html")
    @RequiresPermissions(value={"sys.manager.conf"})
    public void index() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.add"})
    @SLog(tag="\u6dfb\u52a0\u53c2\u6570", msg="${conf.configKey}:${conf.configValue}")
    public Object addDo(@Param(value="..") Sys_config conf) {
        try {
            conf.setOpBy(StringUtil.getPlatformUid());
            conf.setOpAt(Times.getTS());
            if (this.sysConfigService.insert(conf) != null) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.sysConfigService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.edit"})
    @SLog(tag="\u4fee\u6539\u53c2\u6570", msg="${conf.configKey}:${conf.configValue}")
    public Object editDo(@Param(value="..") Sys_config conf) {
        try {
            conf.setOpBy(StringUtil.getPlatformUid());
            conf.setOpAt(Times.getTS());
            if (this.sysConfigService.updateIgnoreNull(conf) > 0) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.conf.delete"})
    @SLog(tag="\u5220\u9664\u53c2\u6570", msg="\u53c2\u6570:${configKey}")
    public Object delete(String configKey) {
        try {
            if (Strings.sBlank((Object)configKey).startsWith("App")) {
                return Result.error((String)"\u7cfb\u7edf\u53c2\u6570\u4e0d\u53ef\u5220\u9664");
            }
            if (this.sysConfigService.delete(configKey) > 0) {
                this.pubSubService.fire("nutzwk:web:platform", "sys_config");
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.conf"})
    public Object data(@Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysConfigService.listPage(pageNumber, pageSize, (Condition)cnd));
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

