/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_log;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.websocket.WkNotifyService;
import cn.wizzer.app.web.commons.shiro.exception.CaptchaEmptyException;
import cn.wizzer.app.web.commons.shiro.exception.CaptchaIncorrectException;
import cn.wizzer.app.web.commons.shiro.filter.PlatformAuthenticationFilter;
import cn.wizzer.app.web.commons.slog.SLogService;
import cn.wizzer.framework.base.Result;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.img.Images;
import org.nutz.integration.jedis.RedisService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.random.R;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Attr;
import org.nutz.mvc.annotation.By;
import org.nutz.mvc.annotation.Filters;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/login"})
@Ok(value="json:{locked:'password|createAt',ignoreNull:true}")
public class SysLoginController {
    private static final Log log = Logs.get();
    @Inject
    private SysUserService sysUserService;
    @Inject
    private SLogService sLogService;
    @Inject
    private RedisService redisService;
    @Inject
    private WkNotifyService wkNotifyService;
    @Inject(value="refer:shiroWebSessionManager")
    private DefaultWebSessionManager webSessionManager;

    @At(value={""})
    @Ok(value="re")
    @Filters
    public String login(HttpServletRequest req, HttpSession session) {
        return "beetl:/platform/sys/login.html";
    }

    @At(value={"/noPermission"})
    @Ok(value="beetl:/platform/sys/noPermission.html")
    @Filters
    public void noPermission() {
    }

    @At(value={"/theme"})
    @RequiresAuthentication
    public void theme(@Param(value="loginTheme") String theme, HttpServletRequest req) {
        Subject subject;
        if (!Strings.isEmpty((CharSequence)theme) && (subject = SecurityUtils.getSubject()) != null) {
            Sys_user user = (Sys_user)subject.getPrincipal();
            user.setLoginTheme(theme);
            this.sysUserService.update(Chain.make((String)"loginTheme", (Object)theme), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
            this.sysUserService.deleteCache(user.getId());
        }
    }

    @At(value={"/menuTheme"})
    @RequiresAuthentication
    public void menuTheme(@Param(value="menuTheme") String theme, HttpServletRequest req) {
        Subject subject;
        if (!Strings.isEmpty((CharSequence)theme) && (subject = SecurityUtils.getSubject()) != null) {
            Sys_user user = (Sys_user)subject.getPrincipal();
            user.setMenuTheme(theme);
            this.sysUserService.update(Chain.make((String)"menuTheme", (Object)theme), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
            this.sysUserService.deleteCache(user.getId());
        }
    }

    @At(value={"/layout"})
    @RequiresAuthentication
    public void layout(@Param(value="p") String p, @Param(value="v") boolean v, HttpServletRequest req) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Sys_user user = (Sys_user)subject.getPrincipal();
            if ("sidebar".equals(p)) {
                this.sysUserService.update(Chain.make((String)"loginSidebar", (Object)v), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
                user.setLoginSidebar(v);
            } else if ("boxed".equals(p)) {
                this.sysUserService.update(Chain.make((String)"loginBoxed", (Object)v), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
                user.setLoginBoxed(v);
            } else if ("scroll".equals(p)) {
                this.sysUserService.update(Chain.make((String)"loginScroll", (Object)v), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
                user.setLoginScroll(v);
            }
            this.sysUserService.deleteCache(user.getId());
        }
    }

    @At(value={"/doLogin"})
    @Ok(value="json")
    @Filters(value={@By(type=PlatformAuthenticationFilter.class)})
    public Object doLogin(@Attr(value="platformLoginToken") AuthenticationToken token, HttpServletRequest req, HttpSession session) {
        int errCount = 0;
        try {
            int count;
            if (token == null) {
                return Result.error((int)7, (String)"login.error.system");
            }
            errCount = NumberUtils.toInt((String)Strings.sNull((Object)SecurityUtils.getSubject().getSession(true).getAttribute((Object)"platformErrCount")));
            Subject subject = SecurityUtils.getSubject();
            ThreadContext.bind((Subject)subject);
            subject.login(token);
            Sys_user user = (Sys_user)subject.getPrincipal();
            int n = count = user.getLoginCount() == null ? 0 : user.getLoginCount();
            if ("true".equals(Globals.MyConfig.getOrDefault((Object)"SysUserSessionOnlyOne", (Object)"false"))) {
                try {
                    Session oldSession;
                    Sys_user oldUser = (Sys_user)this.sysUserService.fetch((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
                    if (oldUser != null && !Strings.sNull((Object)oldUser.getLoginSessionId()).equals(session.getId()) && (oldSession = this.webSessionManager.getSessionDAO().readSession((Serializable)((Object)oldUser.getLoginSessionId()))) != null) {
                        this.wkNotifyService.offline(oldUser.getLoginname(), oldUser.getLoginSessionId());
                        oldSession.stop();
                        this.webSessionManager.getSessionDAO().delete(oldSession);
                    }
                }
                catch (Exception oldUser) {
                    // empty catch block
                }
            }
            this.sysUserService.update(Chain.make((String)"loginIp", (Object)user.getLoginIp()).add("loginAt", (Object)Times.getTS()).add("loginCount", (Object)(count + 1)).add("userOnline", (Object)true).add("loginSessionId", (Object)session.getId()), (Condition)Cnd.where((String)"id", (String)"=", (Object)user.getId()));
            Sys_log sysLog = new Sys_log();
            sysLog.setType("info");
            sysLog.setTag("\u7528\u6237\u767b\u9646");
            sysLog.setSrc(this.getClass().getName() + "#doLogin");
            sysLog.setMsg("\u6210\u529f\u767b\u5f55\u7cfb\u7edf\uff01");
            sysLog.setIp(Lang.getIP((HttpServletRequest)req));
            sysLog.setOpBy(user.getId());
            sysLog.setOpAt(Times.getTS());
            sysLog.setUsername(user.getUsername());
            this.sLogService.async(sysLog);
            return Result.success((String)"login.success");
        }
        catch (CaptchaIncorrectException e) {
            return Result.error((int)1, (String)"login.error.captcha");
        }
        catch (CaptchaEmptyException e) {
            return Result.error((int)2, (String)"login.error.captcha");
        }
        catch (LockedAccountException e) {
            return Result.error((int)3, (String)"login.error.locked");
        }
        catch (UnknownAccountException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            SecurityUtils.getSubject().getSession(true).setAttribute((Object)"platformErrCount", (Object)(++errCount));
            return Result.error((int)4, (String)"login.error.user");
        }
        catch (AuthenticationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            SecurityUtils.getSubject().getSession(true).setAttribute((Object)"platformErrCount", (Object)(++errCount));
            return Result.error((int)5, (String)"login.error.user");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            SecurityUtils.getSubject().getSession(true).setAttribute((Object)"platformErrCount", (Object)(++errCount));
            return Result.error((int)6, (String)"login.error.system");
        }
    }

    @At
    @Ok(value=">>:/platform/login")
    public void logout(HttpSession session, HttpServletRequest req) {
        try {
            Subject currentUser = SecurityUtils.getSubject();
            Sys_user user = (Sys_user)currentUser.getPrincipal();
            currentUser.logout();
            if (user != null) {
                Sys_log sysLog = new Sys_log();
                sysLog.setType("info");
                sysLog.setTag("\u7528\u6237\u767b\u51fa");
                sysLog.setSrc(this.getClass().getName() + "#logout");
                sysLog.setMsg("\u6210\u529f\u9000\u51fa\u7cfb\u7edf\uff01");
                sysLog.setIp(Lang.getIP((HttpServletRequest)req));
                sysLog.setOpBy(user.getId());
                sysLog.setOpAt(Times.getTS());
                sysLog.setUsername(user.getUsername());
                this.sLogService.async(sysLog);
            }
        }
        catch (SessionException ise) {
            log.debug((Object)"Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)ise);
        }
        catch (Exception e) {
            log.debug((Object)"Logout error", (Throwable)e);
        }
    }

    @At(value={"/captcha"})
    @Ok(value="raw:png")
    public BufferedImage next(HttpSession session, @Param(value="w") int w, @Param(value="h") int h) {
        if (w * h < 1) {
            w = 200;
            h = 60;
        }
        String text = R.captchaNumber((int)4);
        this.redisService.setex("platformCaptcha:" + session.getId(), 300, text);
        return Images.createCaptcha((String)text, (int)w, (int)h, null, null, null);
    }
}

