/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.services.SysMsgService;
import cn.wizzer.app.sys.modules.services.SysMsgUserService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/msg/user"})
public class SysMsgUserController {
    private static final Log log = Logs.get();
    @Inject
    private SysMsgUserService sysMsgUserService;
    @Inject
    private SysMsgService sysMsgService;

    @At(value={"/all", "/all/?"})
    @Ok(value="beetl:/platform/sys/msg/user/indexAll.html")
    @RequiresPermissions(value={"sys.msg.all"})
    public void index(String type, HttpServletRequest req) {
        req.setAttribute("type", (Object)(Strings.isBlank((CharSequence)type) ? "all" : type));
    }

    @At(value={"/read", "/read/?"})
    @Ok(value="beetl:/platform/sys/msg/user/indexRead.html")
    @RequiresPermissions(value={"sys.msg.read"})
    public void read(String type, HttpServletRequest req) {
        req.setAttribute("type", (Object)(Strings.isBlank((CharSequence)type) ? "all" : type));
    }

    @At(value={"/unread", "/unread/?"})
    @Ok(value="beetl:/platform/sys/msg/user/indexUnread.html")
    @RequiresPermissions(value={"sys.msg.unread"})
    public void unread(String type, HttpServletRequest req) {
        req.setAttribute("type", (Object)(Strings.isBlank((CharSequence)type) ? "all" : type));
    }

    @At(value={"/data/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    public Object data(String status, @Param(value="searchType") String type, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)status) && "read".equals(status)) {
                cnd.and("a.status", "=", (Object)1);
            }
            if (Strings.isNotBlank((CharSequence)status) && "unread".equals(status)) {
                cnd.and("a.status", "=", (Object)0);
            }
            cnd.and("a.loginname", "=", (Object)StringUtil.getPlatformLoginname());
            cnd.and("a.delFlag", "=", (Object)false);
            cnd.desc("a.opAt");
            if (Strings.isNotBlank((CharSequence)type) && !"all".equals(type)) {
                cnd.and("b.type", "=", (Object)type);
            }
            Sql sql = Sqls.create((String)"SELECT b.type,b.title,b.sendat,a.* FROM sys_msg b LEFT JOIN sys_msg_user a ON b.id=a.msgid $condition");
            sql.setCondition((Condition)cnd);
            Sql sqlCount = Sqls.create((String)"SELECT count(*) FROM sys_msg b LEFT JOIN sys_msg_user a ON b.id=a.msgid $condition");
            sqlCount.setCondition((Condition)cnd);
            return Result.success().addData((Object)this.sysMsgService.listPage(pageNumber, pageSize, sql, sqlCount));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?", "/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="${req.getAttribute('id')}")
    public Object delete(String id, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            if (ids != null && ids.length > 0) {
                this.sysMsgUserService.update(Chain.make((String)"delFlag", (Object)true).add("opAt", (Object)Times.getTS()).add("opBy", (Object)StringUtil.getPlatformUid()), (Condition)Cnd.where((String)"id", (String)"in", (Object)ids).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                this.sysMsgUserService.update(Chain.make((String)"delFlag", (Object)true).add("opAt", (Object)Times.getTS()).add("opBy", (Object)StringUtil.getPlatformUid()), (Condition)Cnd.where((String)"id", (String)"=", (Object)id).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
                req.setAttribute("id", (Object)id);
            }
            this.sysMsgUserService.deleteCache(StringUtil.getPlatformLoginname());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.msg"})
    public Object unread_num() {
        try {
            NutMap nutMap = NutMap.NEW();
            nutMap.put((Object)"system", (Object)this.sysMsgUserService.count(Sqls.create((String)"SELECT count(*) from sys_msg a,sys_msg_user b WHERE a.id=b.msgId AND a.type='system' AND a.delFlag=false AND b.status=0 AND b.delFlag=false AND b.loginname=@loginname").setParam("loginname", (Object)StringUtil.getPlatformLoginname())));
            nutMap.put((Object)"user", (Object)this.sysMsgUserService.count(Sqls.create((String)"SELECT count(*) from sys_msg a,sys_msg_user b WHERE a.id=b.msgId AND a.type='user' AND a.delFlag=false AND b.status=0 AND b.delFlag=false AND b.loginname=@loginname").setParam("loginname", (Object)StringUtil.getPlatformLoginname())));
            return Result.success().addData((Object)nutMap);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/status/read"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="${req.getAttribute('id')}")
    public Object read(@Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            this.sysMsgUserService.update(Chain.make((String)"status", (Object)1).add("readAt", (Object)Times.getTS()).add("opAt", (Object)Times.getTS()).add("opBy", (Object)StringUtil.getPlatformUid()), (Condition)Cnd.where((String)"id", (String)"in", (Object)ids).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
            this.sysMsgUserService.deleteCache(StringUtil.getPlatformLoginname());
            req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            return Result.success((String)"system.success");
        }
        catch (Exception e) {
            return Result.error((String)"system.error");
        }
    }

    @At(value={"/status/readAll"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    @SLog(tag="\u7ad9\u5185\u6d88\u606f", msg="readAll")
    public Object readAll(HttpServletRequest req) {
        try {
            this.sysMsgUserService.update(Chain.make((String)"status", (Object)1).add("readAt", (Object)Times.getTS()).add("opAt", (Object)Times.getTS()).add("opBy", (Object)StringUtil.getPlatformUid()), (Condition)Cnd.where((String)"loginname", (String)"=", (Object)StringUtil.getPlatformLoginname()));
            this.sysMsgUserService.deleteCache(StringUtil.getPlatformLoginname());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/all/detail/?"})
    @Ok(value="beetl:/platform/sys/msg/user/detailAll.html")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    public void allDetail(String id, HttpServletRequest req) {
        if (!Strings.isBlank((CharSequence)id)) {
            int num = this.sysMsgUserService.count((Condition)Cnd.where((String)"msgid", (String)"=", (Object)id).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
            if (num > 0) {
                req.setAttribute("obj", this.sysMsgService.fetch(id));
            } else {
                req.setAttribute("obj", null);
            }
        } else {
            req.setAttribute("obj", null);
        }
    }

    @At(value={"/read/detail/?"})
    @Ok(value="beetl:/platform/sys/msg/user/detailRead.html")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    public void readDetail(String id, HttpServletRequest req) {
        if (!Strings.isBlank((CharSequence)id)) {
            int num = this.sysMsgUserService.count((Condition)Cnd.where((String)"msgid", (String)"=", (Object)id).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
            if (num > 0) {
                req.setAttribute("obj", this.sysMsgService.fetch(id));
            } else {
                req.setAttribute("obj", null);
            }
        } else {
            req.setAttribute("obj", null);
        }
    }

    @At(value={"/unread/detail/?"})
    @Ok(value="beetl:/platform/sys/msg/user/detailUnread.html")
    @RequiresPermissions(value={"sys.msg.all", "sys.msg.read", "sys.msg.unread"}, logical=Logical.OR)
    public void unreadDetail(String id, HttpServletRequest req) {
        if (!Strings.isBlank((CharSequence)id)) {
            int num = this.sysMsgUserService.count((Condition)Cnd.where((String)"msgid", (String)"=", (Object)id).and("loginname", "=", (Object)StringUtil.getPlatformLoginname()));
            if (num > 0) {
                req.setAttribute("obj", this.sysMsgService.fetch(id));
            } else {
                req.setAttribute("obj", null);
            }
        } else {
            req.setAttribute("obj", null);
        }
    }
}

