/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_menu;
import cn.wizzer.app.sys.modules.models.Sys_role;
import cn.wizzer.app.sys.modules.models.Sys_unit;
import cn.wizzer.app.sys.modules.models.Sys_user;
import cn.wizzer.app.sys.modules.services.SysMenuService;
import cn.wizzer.app.sys.modules.services.SysRoleService;
import cn.wizzer.app.sys.modules.services.SysUnitService;
import cn.wizzer.app.sys.modules.services.SysUserService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.ShiroUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/role"})
public class SysRoleController {
    private static final Log log = Logs.get();
    @Inject
    private SysUserService sysUserService;
    @Inject
    private SysMenuService sysMenuService;
    @Inject
    private SysUnitService sysUnitService;
    @Inject
    private SysRoleService sysRoleService;
    @Inject
    private ShiroUtil shiroUtil;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/role/index.html")
    @RequiresPermissions(value={"sys.manager.role"})
    public void index() {
    }

    @At(value={"/tree"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(@Param(value="pid") String pid, HttpServletRequest req) {
        try {
            List list = new ArrayList();
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u5355\u4f4d");
                treeList.add(root);
            }
            if (this.shiroUtil.hasRole("sysadmin")) {
                if (Strings.isBlank((CharSequence)pid)) {
                    NutMap sys = NutMap.NEW().addv("value", (Object)"system").addv("label", (Object)"\u7cfb\u7edf\u89d2\u8272");
                    treeList.add(sys);
                }
                Cnd cnd = Cnd.NEW();
                if (Strings.isBlank((CharSequence)pid)) {
                    cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                } else {
                    cnd.and("parentId", "=", (Object)pid);
                }
                cnd.asc("location").asc("path");
                list = this.sysUnitService.query((Condition)cnd);
            } else {
                Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
                if (user != null && Strings.isBlank((CharSequence)pid)) {
                    list = this.sysUnitService.query((Condition)Cnd.where((String)"id", (String)"=", (Object)user.getUnitid()).asc("path"));
                } else {
                    Cnd cnd = Cnd.NEW();
                    if (Strings.isBlank((CharSequence)pid)) {
                        cnd.and("parentId", "=", (Object)"").or("parentId", "is", null);
                    } else {
                        cnd.and("parentId", "=", (Object)pid);
                    }
                    cnd.asc("location").asc("path");
                    list = this.sysUnitService.query((Condition)cnd);
                }
            }
            for (Sys_unit unit : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)unit.getId()).addv("label", (Object)unit.getName());
                if (unit.isHasChildren()) {
                    map.addv("children", new ArrayList());
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object data(@Param(value="searchUnit") String searchUnit, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (this.shiroUtil.hasRole("sysadmin")) {
                if ("system".equals(searchUnit)) {
                    cnd.and("unitid", "=", (Object)"");
                } else if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    cnd.and("unitid", "=", (Object)searchUnit);
                }
            } else {
                Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
                if (Strings.isNotBlank((CharSequence)searchUnit)) {
                    Sys_unit unit = (Sys_unit)this.sysUnitService.fetch(searchUnit);
                    if (unit == null || !unit.getPath().startsWith(user.getUnit().getPath())) {
                        return Result.error((String)"\u975e\u6cd5\u64cd\u4f5c");
                    }
                    cnd.and("unitid", "=", (Object)searchUnit);
                } else {
                    cnd.and("unitid", "=", (Object)user.getUnitid());
                }
            }
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysRoleService.listPageLinks(pageNumber, pageSize, (Condition)cnd, "unit"));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u542f\u7528\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object enable(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)roleId));
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u7981\u7528\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object disable(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)roleId));
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menuAll"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object menuAll(HttpServletRequest req) {
        try {
            List list = this.shiroUtil.hasRole("sysadmin") ? this.sysMenuService.query((Condition)Cnd.orderBy().asc("location").asc("path")) : this.sysUserService.getMenusAndButtons(StringUtil.getPlatformUid());
            NutMap menuMap = NutMap.NEW();
            for (Sys_menu unit : list) {
                ArrayList<Sys_menu> list1 = menuMap.getList(unit.getParentId(), Sys_menu.class);
                if (list1 == null) {
                    list1 = new ArrayList<Sys_menu>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menuRole/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object menuRole(String roleId, HttpServletRequest req) {
        try {
            List<Sys_menu> hasList = this.sysRoleService.getMenusAndButtons(roleId);
            List list = this.shiroUtil.hasRole("sysadmin") ? this.sysMenuService.query((Condition)Cnd.orderBy().asc("location").asc("path")) : this.sysUserService.getMenusAndButtons(StringUtil.getPlatformUid());
            NutMap menuMap = NutMap.NEW();
            for (Sys_menu unit : list) {
                ArrayList<Sys_menu> list1 = menuMap.getList(unit.getParentId(), Sys_menu.class);
                if (list1 == null) {
                    list1 = new ArrayList<Sys_menu>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            ArrayList<String> cmenu = new ArrayList<String>();
            for (Sys_menu menu : hasList) {
                cmenu.add(menu.getId());
            }
            return Result.success().addData((Object)NutMap.NEW().addv("menu", this.getTree(menuMap, "")).addv("cmenu", cmenu));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        List subList = menuMap.getList(pid, Sys_menu.class);
        for (Sys_menu menu : subList) {
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"label", (Object)menu.getName());
            if (menu.isHasChildren() || menuMap.get((Object)menu.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, menu.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.add"})
    @SLog(tag="\u6dfb\u52a0\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].name}")
    public Object addDo(@Param(value="menuIds") String menuIds, @Param(value="..") Sys_role role, HttpServletRequest req) {
        try {
            int num = this.sysRoleService.count((Condition)Cnd.where((String)"code", (String)"=", (Object)role.getCode().trim()));
            if (num > 0) {
                return Result.error((String)"sys.role.code");
            }
            String[] ids = StringUtils.split((String)menuIds, (String)",");
            if ("root".equals(role.getUnitid()) || "system".equals(role.getUnitid())) {
                role.setUnitid("");
            }
            role.setOpBy(StringUtil.getPlatformUid());
            Sys_role r = (Sys_role)this.sysRoleService.insert(role);
            if (r != null) {
                this.sysRoleService.saveMenu(ids, r.getId());
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/menu/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object menu(String id, @Param(value="pid") String pid) {
        try {
            List<Sys_menu> list = this.sysRoleService.getRoleMenus(id, pid);
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            for (Sys_menu unit : list) {
                if (!unit.isHasChildren() && this.sysRoleService.hasChildren(id, unit.getId())) {
                    unit.setHasChildren(true);
                }
                NutMap map = Lang.obj2nutmap((Object)unit);
                map.addv("expanded", (Object)false);
                map.addv("children", new ArrayList());
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.delete"})
    @SLog(tag="\u5220\u9664\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object delete(String roleId, HttpServletRequest req) {
        try {
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            if ("sysadmin".equals(role.getCode()) || "public".equals(role.getCode())) {
                return Result.error((String)"system.not.allow");
            }
            this.sysRoleService.del(roleId);
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object edit(String roleId, HttpServletRequest req) {
        try {
            return Result.success().addData(this.sysRoleService.fetch(roleId));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.edit"})
    @SLog(tag="\u4fee\u6539\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[0].name}")
    public Object editDo(@Param(value="..") Sys_role role, HttpServletRequest req) {
        try {
            int num;
            Sys_role oldRole = (Sys_role)this.sysRoleService.fetch(role.getId());
            if (oldRole != null && !Strings.sBlank((Object)oldRole.getCode()).equalsIgnoreCase(role.getCode()) && (num = this.sysRoleService.count((Condition)Cnd.where((String)"code", (String)"=", (Object)role.getCode().trim()))) > 0) {
                return Result.error((String)"sys.role.code");
            }
            if ("root".equals(role.getUnitid()) || "system".equals(role.getUnitid())) {
                role.setUnitid("");
            }
            role.setOpBy(StringUtil.getPlatformUid());
            role.setOpAt(Times.getTS());
            this.sysRoleService.updateIgnoreNull(role);
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.menu"})
    @SLog(tag="\u5206\u914d\u89d2\u8272\u83dc\u5355", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')}")
    public Object menuDo(@Param(value="menuIds") String menuIds, @Param(value="roleId") String roleId, HttpServletRequest req) {
        try {
            String[] ids = StringUtils.split((String)menuIds, (String)",");
            this.sysRoleService.saveMenu(ids, roleId);
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object user(@Param(value="roleId") String roleId, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Sql sql = Sqls.create((String)"SELECT a.*,c.name as unitname FROM sys_user a,sys_user_role b,sys_unit c WHERE a.unitid=c.id and a.id=b.userId and b.roleId=@roleId $s $o");
            sql.params().set("roleId", (Object)roleId);
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                sql.vars().set("s", (Object)(" and a." + searchName + " like '%" + searchKeyword + "%'"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                sql.vars().set("o", (Object)(" order by a." + pageOrderName + " " + PageUtil.getOrder(pageOrderBy)));
            }
            return Result.success().addData((Object)this.sysUserService.listPage(pageNumber, pageSize, sql));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.role"})
    public Object userSearch(@Param(value="query") String keyword, @Param(value="roleId") String roleId) {
        try {
            Sys_user user = (Sys_user)this.shiroUtil.getPrincipal();
            return Result.success().addData((Object)this.sysRoleService.userSearch(roleId, keyword, this.shiroUtil.hasRole("sysadmin"), user.getUnit()));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.user"})
    @SLog(tag="\u6dfb\u52a0\u7528\u6237\u5230\u89d2\u8272", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')},\u7528\u6237ID:${args[0]}")
    public Object usersAdd(@Param(value="users") String users, @Param(value="roleId") String roleId, HttpServletRequest req) {
        try {
            String[] ids;
            for (String s : ids = StringUtils.split((String)users, (String)",")) {
                this.sysRoleService.insert("sys_user_role", Chain.make((String)"roleId", (Object)roleId).add("userId", (Object)s));
            }
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.role.user"})
    @SLog(tag="\u4ece\u89d2\u8272\u4e2d\u79fb\u9664\u7528\u6237", msg="\u89d2\u8272\u540d\u79f0:${args[2].getAttribute('name')},\u7528\u6237ID:${args[0]}")
    public Object usersDel(@Param(value="users") String users, @Param(value="roleId") String roleId, HttpServletRequest req) {
        try {
            String superadminId = ((Sys_user)this.sysUserService.fetch((Condition)Cnd.where((String)"loginname", (String)"=", (Object)"superadmin"))).getId();
            String sysadminRoleid = ((Sys_role)this.sysRoleService.fetch((Condition)Cnd.where((String)"code", (String)"=", (Object)"sysadmin"))).getId();
            Object[] ids = StringUtils.split((String)users, (String)",");
            if (Lang.contains((Object[])ids, (Object)superadminId) && roleId.equals(sysadminRoleid)) {
                return Result.error((String)"\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u4ece[\u7cfb\u7edf\u7ba1\u7406\u5458]\u89d2\u8272\u91cc\u5220\u9664");
            }
            this.sysRoleService.clear("sys_user_role", (Condition)Cnd.where((String)"userId", (String)"in", (Object)ids).and("roleId", "=", (Object)roleId));
            Sys_role role = (Sys_role)this.sysRoleService.fetch(roleId);
            this.sysRoleService.clearCache();
            this.sysUserService.clearCache();
            req.setAttribute("name", (Object)role.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

