/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.sys;

import cn.wizzer.app.sys.modules.models.Sys_task;
import cn.wizzer.app.sys.modules.services.SysTaskService;
import cn.wizzer.app.task.modules.services.TaskPlatformService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.framework.base.Result;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/sys/task"})
public class SysTaskController {
    private static final Log log = Logs.get();
    @Inject
    private SysTaskService sysTaskService;
    @Inject
    private TaskPlatformService taskPlatformService;

    @At(value={""})
    @Ok(value="beetl:/platform/sys/task/index.html")
    @RequiresPermissions(value={"sys.manager.task"})
    public void index() {
    }

    @At
    @Ok(value="beetl:/platform/sys/task/cron.html")
    @RequiresPermissions(value={"sys.manager.task"})
    public void cron() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task"})
    public Object cronExp(@Param(value="cron") String cron) {
        try {
            return Result.success().addData(this.taskPlatformService.getCronExeTimes(cron));
        }
        catch (Exception e) {
            return Result.error((String)e.getMessage());
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"sys.manager.task"})
    public Object data(@Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.sysTaskService.listPage(pageNumber, pageSize, (Condition)cnd));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u65b0\u5efa\u4efb\u52a1", msg="\u4efb\u52a1\u540d\u79f0:${args[0].name}")
    @RequiresPermissions(value={"sys.manager.task.add"})
    public Object addDo(@Param(value="..") Sys_task task, HttpServletRequest req) {
        try {
            task.setOpBy(StringUtil.getPlatformUid());
            Sys_task sysTask = (Sys_task)this.sysTaskService.insert(task);
            this.taskPlatformService.add(sysTask.getId(), sysTask.getId(), sysTask.getJobClass(), sysTask.getCron(), sysTask.getNote(), sysTask.getData());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.sysTaskService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u4fee\u6539\u4efb\u52a1", msg="\u4efb\u52a1\u540d\u79f0:${args[0].name}")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    public Object editDo(@Param(value="..") Sys_task task, HttpServletRequest req) {
        try {
            task.setOpBy(StringUtil.getPlatformUid());
            task.setOpAt(Times.getTS());
            this.sysTaskService.updateIgnoreNull(task);
            if (this.taskPlatformService.isExist(task.getId(), task.getId())) {
                this.taskPlatformService.delete(task.getId(), task.getId());
            }
            if (!task.isDisabled()) {
                this.taskPlatformService.add(task.getId(), task.getId(), task.getJobClass(), task.getCron(), task.getNote(), task.getData());
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @SLog(tag="\u5220\u9664\u4efb\u52a1", msg="\u4efb\u52a1\u540d\u79f0:${args[1].getAttribute('name')}")
    @RequiresPermissions(value={"sys.manager.task.delete"})
    public Object delete(String id, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
            try {
                if (this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                    this.taskPlatformService.delete(sysTask.getId(), sysTask.getId());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
            this.sysTaskService.delete(id);
            req.setAttribute("name", (Object)sysTask.getName());
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/enable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    @SLog(tag="\u542f\u7528\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[1].getAttribute('name')}")
    public Object enable(String id, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
            req.setAttribute("name", (Object)sysTask.getName());
            this.sysTaskService.update(Chain.make((String)"disabled", (Object)false), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            if (!this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                this.taskPlatformService.add(sysTask.getId(), sysTask.getId(), sysTask.getJobClass(), sysTask.getCron(), sysTask.getNote(), sysTask.getData());
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/disable/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"sys.manager.task.edit"})
    @SLog(tag="\u7981\u7528\u4efb\u52a1", msg="\u4efb\u52a1\u540d:${args[1].getAttribute('name')}")
    public Object disable(String id, HttpServletRequest req) {
        try {
            Sys_task sysTask = (Sys_task)this.sysTaskService.fetch(id);
            req.setAttribute("name", (Object)sysTask.getName());
            this.sysTaskService.update(Chain.make((String)"disabled", (Object)true), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
            if (this.taskPlatformService.isExist(sysTask.getId(), sysTask.getId())) {
                this.taskPlatformService.delete(sysTask.getId(), sysTask.getId());
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

