/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.framework.base.Result;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.integration.jedis.pubsub.PubSubService;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/wx/conf/account"})
public class WxConfigController {
    private static final Log log = Logs.get();
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private PubSubService pubSubService;

    @At(value={""})
    @Ok(value="beetl:/platform/wx/account/index.html")
    @RequiresPermissions(value={"wx.conf.account"})
    public void index() {
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.account.add"})
    @SLog(tag="\u6dfb\u52a0\u5e10\u53f7", msg="\u5e10\u53f7\u540d\u79f0:${args[0].appname}")
    public Object addDo(@Param(value="..") Wx_config conf, HttpServletRequest req) {
        try {
            int num = this.wxConfigService.count((Condition)Cnd.where((String)"id", (String)"=", (Object)conf.getId()));
            if (num > 0) {
                return Result.error((String)"\u552f\u4e00\u6807\u8bc6\u5df2\u5b58\u5728,\u8bf7\u66f4\u6362");
            }
            conf.setOpBy(StringUtil.getPlatformUid());
            this.wxConfigService.insert(conf);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.account"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.wxConfigService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.account.edit"})
    @SLog(tag="\u4fee\u6539\u5e10\u53f7", msg="\u5e10\u53f7\u540d\u79f0:${args[0].appname}")
    public Object editDo(@Param(value="..") Wx_config conf, HttpServletRequest req) {
        try {
            this.wxConfigService.updateIgnoreNull(conf);
            this.pubSubService.fire("nutzwk:web:platform", "sys_wx");
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.account.delete"})
    @SLog(tag="\u5220\u9664\u5e10\u53f7", msg="\u5e10\u53f7\u540d\u79f0:${args[1].getAttribute('appname')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            req.setAttribute("appname", (Object)((Wx_config)this.wxConfigService.fetch(id)).getAppname());
            this.wxConfigService.delete(id);
            this.pubSubService.fire("nutzwk:web:platform", "sys_wx");
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.conf.account"})
    public Object data(@Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.wxConfigService.listPage(pageNumber, pageSize, (Condition)cnd));
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

