/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.base.Globals;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.DateUtil;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_mass;
import cn.wizzer.app.wx.modules.models.Wx_mass_news;
import cn.wizzer.app.wx.modules.models.Wx_mass_send;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxMassNewsService;
import cn.wizzer.app.wx.modules.services.WxMassSendService;
import cn.wizzer.app.wx.modules.services.WxMassService;
import cn.wizzer.framework.base.Result;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.boot.starter.ftp.FtpService;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.AdaptBy;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.POST;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.impl.AdaptorErrorContext;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadAdaptor;
import org.nutz.weixin.bean.WxMassArticle;
import org.nutz.weixin.bean.WxOutMsg;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/msg/mass"})
public class WxMassController {
    private static final Log log = Logs.get();
    @Inject
    private WxMassService wxMassService;
    @Inject
    private WxMassSendService wxMassSendService;
    @Inject
    private WxMassNewsService wxMassNewsService;
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;
    @Inject
    private FtpService ftpService;
    @Inject
    private PropertiesProxy conf;

    @At(value={"/", "/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/index.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void index(String wxid, HttpServletRequest req, HttpSession session) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object massData(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxMassService.listPageLinks(pageNumber, pageSize, (Condition)cnd, "massSend"));
    }

    @At(value={"/news/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/news.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void news(String wxid, HttpServletRequest req, HttpSession session) {
        req.setAttribute("wxid", (Object)wxid);
        session.setAttribute("wxid", (Object)wxid);
    }

    @At(value={"/newsData/?"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object newsData(String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (!Strings.isBlank((CharSequence)searchName) && !Strings.isBlank((CharSequence)searchKeyword)) {
            cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
        }
        return Result.success().addData((Object)this.wxMassNewsService.listPage(pageNumber, pageSize, (Condition)cnd));
    }

    @At(value={"/deleteNews/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.delNews"})
    @SLog(tag="\u5220\u9664\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[1].getAttribute('title')}}")
    public Object deleteNews(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Wx_mass_news)this.wxMassNewsService.fetch(id)).getTitle());
            this.wxMassNewsService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.addNews"})
    @SLog(tag="\u6dfb\u52a0\u56fe\u6587", msg="\u56fe\u6587\u6807\u9898:${args[0].title}")
    public Object addDo(@Param(value="..") Wx_mass_news news, HttpServletRequest req) {
        try {
            news.setOpBy(StringUtil.getPlatformUid());
            this.wxMassNewsService.insert(news);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/newsDetail/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object newsDetail(String id, HttpServletRequest req) {
        try {
            return Result.success().addData(this.wxMassNewsService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/uploadThumb/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object uploadThumb(String wxid, @Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.media_upload("thumb", tf.getFile());
            if (resp.errcode() != 0) {
                return Result.error((String)resp.errmsg());
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".")).toLowerCase();
            String filePath = Globals.AppUploadBase + "/image/" + DateUtil.format(new Date(), "yyyyMMdd") + "/";
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.conf.getBoolean("ftp.enabled")) {
                if (this.ftpService.upload(filePath, fileName, tf.getInputStream())) {
                    return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("id", resp.get((Object)"thumb_media_id")).addv("picurl", (Object)url));
                }
                return Result.error((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ftp\u7528\u6237\u662f\u5426\u6709\u521b\u5efa\u76ee\u5f55\u6743\u9650");
            }
            String staticPath = this.conf.get("jetty.staticPath", "/files");
            Files.write((String)(staticPath + url), (Object)tf.getInputStream());
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("id", resp.get((Object)"thumb_media_id")).addv("picurl", (Object)url));
        }
        catch (Exception e) {
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }

    @AdaptBy(type=UploadAdaptor.class, args={"ioc:imageUpload"})
    @POST
    @At(value={"/uploadImage/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass"})
    public Object uploadImage(String wxid, @Param(value="Filedata") TempFile tf, HttpServletRequest req, AdaptorErrorContext err) {
        try {
            if (err != null && err.getAdaptorErr() != null) {
                return NutMap.NEW().addv("code", (Object)1).addv("msg", (Object)"\u6587\u4ef6\u4e0d\u5408\u6cd5");
            }
            if (tf == null) {
                return Result.error((String)"\u7a7a\u6587\u4ef6");
            }
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            WxResp resp = wxApi2.add_material("image", tf.getFile());
            if (resp.errcode() != 0) {
                return Result.error((String)resp.errmsg());
            }
            String suffixName = tf.getSubmittedFileName().substring(tf.getSubmittedFileName().lastIndexOf(".") + 1).toLowerCase();
            String filePath = Globals.AppUploadBase + "/image/" + DateUtil.format(new Date(), "yyyyMMdd");
            String fileName = R.UU32() + suffixName;
            String url = filePath + fileName;
            if (this.conf.getBoolean("ftp.enabled")) {
                this.ftpService.upload(filePath, fileName, tf.getInputStream());
            } else {
                String staticPath = this.conf.get("jetty.staticPath", "/files");
                Files.write((String)(staticPath + url), (Object)tf.getInputStream());
            }
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)NutMap.NEW().addv("id", resp.get((Object)"media_id")).addv("picurl", (Object)url));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return Result.error((String)"\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        }
    }

    @At(value={"/send/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/send.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void send(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
    }

    @At(value={"/select/?"})
    @Ok(value="beetl:/platform/wx/msg/mass/select.html")
    @RequiresPermissions(value={"wx.msg.mass"})
    public void select(String wxid, HttpServletRequest req) {
        req.setAttribute("wxid", (Object)wxid);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.msg.mass.pushNews"})
    @SLog(tag="\u7fa4\u53d1\u6d88\u606f", msg="\u7fa4\u53d1\u540d\u79f0:${args[0].name}")
    public Object sendDo(@Param(value="..") Wx_mass mass, @Param(value="receivers") String openids, @Param(value="newsids") String newsids, HttpServletRequest req) {
        try {
            WxResp resp;
            WxApi2 wxApi2 = this.wxService.getWxApi2(mass.getWxid());
            WxOutMsg outMsg = new WxOutMsg();
            if ("news".equals(mass.getType())) {
                String[] ids = StringUtils.split((String)newsids, (String)",");
                int i = 0;
                for (String id : ids) {
                    this.wxMassNewsService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
                    ++i;
                }
                List newsList = this.wxMassNewsService.query((Condition)Cnd.where((String)"id", (String)"in", (Object)ids).asc("location"));
                List articles = Json.fromJsonAsList(WxMassArticle.class, (CharSequence)Json.toJson((Object)newsList));
                WxResp resp2 = wxApi2.uploadnews(articles);
                log.debug((Object)resp2);
                String media_id = resp2.media_id();
                mass.setMedia_id(media_id);
                outMsg.setMedia_id(media_id);
                outMsg.setMsgType("mpnews");
            }
            if ("text".equals(mass.getType())) {
                outMsg.setContent(mass.getContent());
                outMsg.setMsgType("text");
            }
            if ("image".equals(mass.getType())) {
                outMsg.setMedia_id(mass.getMedia_id());
                outMsg.setMsgType("image");
            }
            if ("all".equals(mass.getScope())) {
                resp = wxApi2.mass_sendall(true, null, outMsg);
            } else {
                String[] ids = StringUtils.split((String)openids, (String)",");
                resp = wxApi2.mass_send(Arrays.asList(ids), outMsg);
            }
            log.debug((Object)resp);
            int status = resp.errcode() == 0 ? 1 : 2;
            String errmsg = resp.getString("errmsg");
            if (status != 1) {
                return Result.error((String)errmsg);
            }
            mass.setStatus(resp.errcode() == 0 ? 1 : 2);
            Wx_mass wxMass = (Wx_mass)this.wxMassService.insert(mass);
            Wx_mass_send send = new Wx_mass_send();
            send.setWxid(wxMass.getWxid());
            send.setMassId(wxMass.getId());
            send.setErrCode(String.valueOf(resp.errcode()));
            send.setMsgId(resp.getString("msg_id"));
            if (!"all".equals(mass.getScope())) {
                send.setReceivers(openids);
            }
            send.setErrMsg(errmsg);
            send.setStatus(status);
            this.wxMassSendService.insert(send);
            return Result.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error();
        }
    }
}

