/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.cms.modules.services.CmsArticleService;
import cn.wizzer.app.cms.modules.services.CmsChannelService;
import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_menu;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxMenuService;
import cn.wizzer.app.wx.modules.services.WxReplyService;
import cn.wizzer.framework.base.Result;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.bean.WxMenu;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/conf/menu"})
public class WxMenuController {
    private static final Log log = Logs.get();
    @Inject
    private WxMenuService wxMenuService;
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private WxReplyService wxReplyService;
    @Inject
    private CmsChannelService cmsChannelService;
    @Inject
    private CmsArticleService cmsArticleService;
    @Inject
    private WxService wxService;

    @At(value={"", "/index/?"})
    @Ok(value="beetl:/platform/wx/menu/index.html")
    @RequiresPermissions(value={"wx.conf.menu"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At(value={"/child"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object child(@Param(value="pid") String pid, @Param(value="wxid") String wxid, HttpServletRequest req) {
        List list = new ArrayList();
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        Cnd cnd = Cnd.NEW();
        if (Strings.isBlank((CharSequence)pid)) {
            cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
        } else {
            cnd.and("parentId", "=", (Object)pid);
        }
        cnd.and("wxid", "=", (Object)wxid);
        cnd.asc("location").asc("path");
        list = this.wxMenuService.query((Condition)cnd);
        for (Wx_menu menu : list) {
            if (this.wxMenuService.count((Condition)Cnd.where((String)"parentId", (String)"=", (Object)menu.getId())) > 0) {
                menu.setHasChildren(true);
            }
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.addv("expanded", (Object)false);
            map.addv("children", new ArrayList());
            treeList.add(map);
        }
        return Result.success().addData(treeList);
    }

    @At(value={"/tree"})
    @Ok(value="json")
    @RequiresAuthentication
    public Object tree(@Param(value="pid") String pid, @Param(value="wxid") String wxid, HttpServletRequest req) {
        try {
            ArrayList<NutMap> treeList = new ArrayList<NutMap>();
            if (Strings.isBlank((CharSequence)pid)) {
                NutMap root = NutMap.NEW().addv("value", (Object)"root").addv("label", (Object)"\u4e0d\u9009\u62e9\u83dc\u5355").addv("leaf", (Object)true);
                treeList.add(root);
            }
            Cnd cnd = Cnd.NEW();
            if (Strings.isBlank((CharSequence)pid)) {
                cnd.and((SqlExpression)Cnd.exps((String)"parentId", (String)"=", (Object)"").or("parentId", "is", null));
            } else {
                cnd.and("parentId", "=", (Object)pid);
            }
            cnd.and("wxid", "=", (Object)wxid);
            cnd.asc("location").asc("path");
            List list = this.wxMenuService.query((Condition)cnd);
            for (Wx_menu menu : list) {
                NutMap map = NutMap.NEW().addv("value", (Object)menu.getId()).addv("label", (Object)menu.getMenuName());
                if (menu.isHasChildren()) {
                    map.addv("children", new ArrayList());
                    map.addv("leaf", (Object)false);
                } else {
                    map.addv("leaf", (Object)true);
                }
                treeList.add(map);
            }
            return Result.success().addData(treeList);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu.add"})
    @SLog(tag="\u6dfb\u52a0\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[0].menuName}")
    public Object addDo(@Param(value="..") Wx_menu menu, @Param(value="parentId", df="") String parentId, HttpServletRequest req) {
        try {
            if ("root".equals(parentId)) {
                parentId = "";
            }
            if (Strings.isBlank((CharSequence)menu.getWxid())) {
                return Result.error((String)"\u8bf7\u9009\u62e9\u516c\u4f17\u53f7");
            }
            int count = this.wxMenuService.count((Condition)Cnd.where((String)"wxid", (String)"=", (Object)Strings.sBlank((Object)menu.getWxid())).and("parentId", "=", (Object)Strings.sBlank((Object)parentId)));
            if (Strings.isBlank((CharSequence)parentId) && count > 2) {
                return Result.error((String)"\u53ea\u53ef\u8bbe\u7f6e\u4e09\u4e2a\u4e00\u7ea7\u83dc\u5355");
            }
            if (!Strings.isBlank((CharSequence)parentId) && count > 4) {
                return Result.error((String)"\u53ea\u53ef\u8bbe\u7f6e\u4e94\u4e2a\u4e8c\u7ea7\u83dc\u5355");
            }
            menu.setOpBy(StringUtil.getPlatformUid());
            this.wxMenuService.save(menu, parentId);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu.sort"})
    public Object sortDo(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.wxMenuService.execute(Sqls.create((String)"update wx_menu set location=0"));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.wxMenuService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu"})
    public Object edit(String id, HttpServletRequest req) {
        try {
            Wx_menu menu = (Wx_menu)this.wxMenuService.fetch(id);
            return Result.success().addData((Object)menu);
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu.edit"})
    @SLog(tag="\u4fee\u6539\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[0].menuName}")
    public Object editDo(@Param(value="..") Wx_menu menu, HttpServletRequest req) {
        try {
            this.wxMenuService.updateIgnoreNull(menu);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu.delete"})
    @SLog(tag="\u5220\u9664\u83dc\u5355", msg="\u83dc\u5355\u540d\u79f0:${args[1].getAttribute('menuName')}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            Wx_menu menu = (Wx_menu)this.wxMenuService.fetch(id);
            req.setAttribute("menuName", (Object)menu.getMenuName());
            this.wxMenuService.deleteAndChild(menu);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    /*
     * WARNING - void declaration
     */
    @At(value={"/pushMenu"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu.push"})
    @SLog(tag="\u63a8\u9001\u83dc\u5355", msg="\u516c\u4f17\u53f7\u540d\u79f0:${args[1].getAttribute('name')}")
    public Object pushMenu(@Param(value="wxid") String wxid, HttpServletRequest req) {
        try {
            Wx_config config = (Wx_config)this.wxConfigService.fetch(wxid);
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            List list = this.wxMenuService.query((Condition)Cnd.where((String)"wxid", (String)"=", (Object)wxid).asc("location"));
            req.setAttribute("name", (Object)config.getAppname());
            ArrayList<Object> firstMenus = new ArrayList<Object>();
            HashMap<String, void> secondMenus = new HashMap<String, void>();
            for (Object menu : list) {
                if (((Wx_menu)menu).getPath().length() > 4) {
                    void var10_11;
                    List list2 = (List)secondMenus.get(this.wxMenuService.getParentPath(((Wx_menu)menu).getPath()));
                    if (list2 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var10_11.add(menu);
                    secondMenus.put(this.wxMenuService.getParentPath(((Wx_menu)menu).getPath()), var10_11);
                    continue;
                }
                if (((Wx_menu)menu).getPath().length() != 4) continue;
                firstMenus.add(menu);
            }
            ArrayList<WxMenu> m1 = new ArrayList<WxMenu>();
            for (Wx_menu wx_menu : firstMenus) {
                WxMenu xm1 = new WxMenu();
                if (wx_menu.isHasChildren()) {
                    ArrayList<WxMenu> m2 = new ArrayList<WxMenu>();
                    xm1.setName(wx_menu.getMenuName());
                    if (((List)secondMenus.get(wx_menu.getPath())).size() > 0) {
                        for (Wx_menu secondMenu : (List)secondMenus.get(wx_menu.getPath())) {
                            WxMenu xm2 = new WxMenu();
                            if ("view".equals(secondMenu.getMenuType())) {
                                xm2.setType(secondMenu.getMenuType());
                                xm2.setUrl(secondMenu.getUrl());
                                xm2.setName(secondMenu.getMenuName());
                            } else if ("click".equals(secondMenu.getMenuType())) {
                                xm2.setType(secondMenu.getMenuType());
                                xm2.setKey(secondMenu.getMenuKey());
                                xm2.setName(secondMenu.getMenuName());
                            } else if ("miniprogram".equals(secondMenu.getMenuType())) {
                                xm2.setType(secondMenu.getMenuType());
                                xm2.setName(secondMenu.getMenuName());
                                xm2.setUrl(secondMenu.getUrl());
                                xm2.setAppid(secondMenu.getAppid());
                                xm2.setPagepath(secondMenu.getPagepath());
                            } else {
                                xm2.setName(secondMenu.getMenuName());
                                xm2.setType("click");
                                xm2.setKey(secondMenu.getMenuName());
                            }
                            m2.add(xm2);
                        }
                        xm1.setSubButtons(m2);
                    }
                    m1.add(xm1);
                    continue;
                }
                WxMenu xm2 = new WxMenu();
                if ("view".equals(wx_menu.getMenuType())) {
                    xm2.setType(wx_menu.getMenuType());
                    xm2.setUrl(wx_menu.getUrl());
                    xm2.setName(wx_menu.getMenuName());
                } else if ("click".equals(wx_menu.getMenuType())) {
                    xm2.setType(wx_menu.getMenuType());
                    xm2.setKey(wx_menu.getMenuKey());
                    xm2.setName(wx_menu.getMenuName());
                } else if ("miniprogram".equals(wx_menu.getMenuType())) {
                    xm2.setType(wx_menu.getMenuType());
                    xm2.setName(wx_menu.getMenuName());
                    xm2.setUrl(wx_menu.getUrl());
                    xm2.setAppid(wx_menu.getAppid());
                    xm2.setPagepath(wx_menu.getPagepath());
                } else {
                    xm2.setName(wx_menu.getMenuName());
                    xm2.setType("click");
                    xm2.setKey(wx_menu.getMenuName());
                }
                m1.add(xm2);
            }
            WxResp wxResp = wxApi2.menu_create(m1);
            if (wxResp.errcode() != 0) {
                return Result.error((String)wxResp.errmsg());
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error((String)"\u8bf7\u68c0\u67e5\u767d\u540d\u5355IP\u662f\u5426\u914d\u7f6e");
        }
    }

    @At(value={"/keywordData"})
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.conf.menu"})
    public Object data(@Param(value="wxid") String wxid) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        cnd.and("type", "=", (Object)"keyword");
        return Result.success().addData((Object)this.wxReplyService.query((Condition)cnd));
    }

    @At(value={"/sort"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu"})
    public Object sort(@Param(value="wxid") String wxid, HttpServletRequest req) {
        try {
            List list = this.wxMenuService.query((Condition)Cnd.where((String)"wxid", (String)"=", (Object)wxid).asc("location").asc("path"));
            NutMap menuMap = NutMap.NEW();
            for (Wx_menu unit : list) {
                ArrayList<Wx_menu> list1 = menuMap.getList(unit.getParentId(), Wx_menu.class);
                if (list1 == null) {
                    list1 = new ArrayList<Wx_menu>();
                }
                list1.add(unit);
                menuMap.put((Object)unit.getParentId(), list1);
            }
            return Result.success().addData(this.getTree(menuMap, ""));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    private List<NutMap> getTree(NutMap menuMap, String pid) {
        ArrayList<NutMap> treeList = new ArrayList<NutMap>();
        List subList = menuMap.getList(pid, Wx_menu.class);
        for (Wx_menu menu : subList) {
            NutMap map = Lang.obj2nutmap((Object)menu);
            map.put((Object)"label", (Object)menu.getMenuName());
            if (menu.isHasChildren() || menuMap.get((Object)menu.getId()) != null) {
                map.put((Object)"children", this.getTree(menuMap, menu.getId()));
            }
            treeList.add(map);
        }
        return treeList;
    }

    @At(value={"/sortDo"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.conf.menu"})
    public Object sortDo(@Param(value="wxid") String wxid, @Param(value="ids") String ids, HttpServletRequest req) {
        try {
            String[] menuIds = StringUtils.split((String)ids, (String)",");
            int i = 0;
            this.wxMenuService.execute(Sqls.create((String)"update wx_menu set location=0 where wxid=@wxid").setParam("wxid", (Object)wxid));
            for (String s : menuIds) {
                if (Strings.isBlank((CharSequence)s)) continue;
                this.wxMenuService.update(Chain.make((String)"location", (Object)i), (Condition)Cnd.where((String)"id", (String)"=", (Object)s));
                ++i;
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

