/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_reply_txt;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxReplyTxtService;
import cn.wizzer.framework.base.Result;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;

@IocBean
@At(value={"/platform/wx/reply/txt"})
public class WxReplyTxtController {
    private static final Log log = Logs.get();
    @Inject
    private WxReplyTxtService wxReplyTxtService;
    @Inject
    private WxConfigService wxConfigService;

    @At(value={"/", "/index/?"})
    @Ok(value="beetl:/platform/wx/reply/txt/index.html")
    @RequiresPermissions(value={"wx.reply"})
    public void index(String wxid, HttpServletRequest req, HttpSession session) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.txt.add"})
    @SLog(tag="\u6dfb\u52a0\u56de\u590d\u6587\u672c", msg="\u6587\u672c\u6807\u9898:${args[0].title}")
    public Object addDo(@Param(value="..") Wx_reply_txt txt, HttpServletRequest req) {
        try {
            txt.setOpBy(StringUtil.getPlatformUid());
            this.wxReplyTxtService.insert(txt);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/edit/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply"})
    public Object edit(String id) {
        try {
            return Result.success().addData(this.wxReplyTxtService.fetch(id));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.txt.edit"})
    @SLog(tag="\u4fee\u6539\u56de\u590d\u6587\u672c", msg="\u6587\u672c\u6807\u9898:${args[0].title}")
    public Object editDo(@Param(value="..") Wx_reply_txt txt, HttpServletRequest req) {
        try {
            this.wxReplyTxtService.updateIgnoreNull(txt);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.txt.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u6587\u672c", msg="\u6587\u672c\u6807\u9898:${args[1].getAttribute('title')}}")
    public Object delete(String id, HttpServletRequest req) {
        try {
            req.setAttribute("title", (Object)((Wx_reply_txt)this.wxReplyTxtService.fetch(id)).getTitle());
            this.wxReplyTxtService.delete(id);
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.reply.txt.delete"})
    @SLog(tag="\u5220\u9664\u56de\u590d\u6587\u672c", msg="ID:${args[0]}")
    public Object deletes(@Param(value="ids") String ids, HttpServletRequest req) {
        try {
            this.wxReplyTxtService.delete(StringUtils.split((String)ids, (String)","));
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.reply"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (Strings.isNotBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
            cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
        }
        return Result.success().addData((Object)this.wxReplyTxtService.listPage(pageNumber, pageSize, (Condition)cnd));
    }
}

