/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.StringUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_tpl_id;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxTplIdService;
import cn.wizzer.framework.base.Result;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.util.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/tpl/id"})
public class WxTplIdController {
    private static final Log log = Logs.get();
    @Inject
    private WxTplIdService wxTplIdService;
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={"", "/index/?"})
    @Ok(value="beetl:/platform/wx/tpl/id/index.html")
    @RequiresPermissions(value={"wx.tpl.id"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json:full")
    @RequiresPermissions(value={"wx.tpl.id"})
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        Cnd cnd = Cnd.NEW();
        if (!Strings.isBlank((CharSequence)wxid)) {
            cnd.and("wxid", "=", (Object)wxid);
        }
        return Result.success().addData((Object)this.wxTplIdService.listPage(pageNumber, pageSize, (Condition)cnd));
    }

    @At
    @Ok(value="json")
    @SLog(tag="\u6dfb\u52a0\u6a21\u677f", msg="")
    @RequiresPermissions(value={"wx.tpl.id.add"})
    public Object addDo(@Param(value="..") Wx_tpl_id wxTplId, HttpServletRequest req) {
        try {
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxTplId.getWxid());
            WxResp wxResp = wxApi2.template_api_add_template(wxTplId.getId());
            if (wxResp.errcode() == 0) {
                wxTplId.setOpBy(StringUtil.getPlatformUid());
                wxTplId.setTemplate_id(wxResp.template_id());
                this.wxTplIdService.insert(wxTplId);
                return Result.success();
            }
            return Result.error((String)wxResp.errmsg());
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/delete", "/delete/?"})
    @Ok(value="json")
    @SLog(tag="\u5220\u9664\u6a21\u677f", msg="ID:${args[3].getAttribute('id')}")
    @RequiresPermissions(value={"wx.tpl.id.delete"})
    public Object delete(String id, @Param(value="wxid") String wxid, @Param(value="ids") String[] ids, HttpServletRequest req) {
        try {
            WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            if (ids != null && ids.length > 0) {
                for (String i : ids) {
                    Wx_tpl_id wxTplId = (Wx_tpl_id)this.wxTplIdService.fetch((Condition)Cnd.where((String)"id", (String)"=", (Object)id).and("wxid", "=", (Object)wxid));
                    WxResp wxResp = wxApi2.template_api_del_template(wxTplId.getTemplate_id());
                    if (wxResp.errcode() != 0) continue;
                    this.wxTplIdService.clear((Condition)Cnd.where((String)"id", (String)"=", (Object)i).and("wxid", "=", (Object)wxid));
                    return Result.success();
                }
                this.wxTplIdService.delete(ids);
                req.setAttribute("id", (Object)StringUtils.toString((Object[])ids));
            } else {
                Wx_tpl_id wxTplId = (Wx_tpl_id)this.wxTplIdService.fetch((Condition)Cnd.where((String)"id", (String)"=", (Object)id).and("wxid", "=", (Object)wxid));
                WxResp wxResp = wxApi2.template_api_del_template(wxTplId.getTemplate_id());
                if (wxResp.errcode() == 0) {
                    this.wxTplIdService.clear((Condition)Cnd.where((String)"id", (String)"=", (Object)id).and("wxid", "=", (Object)wxid));
                    return Result.success();
                }
                req.setAttribute("id", (Object)id);
            }
            return Result.success();
        }
        catch (Exception e) {
            return Result.error();
        }
    }
}

