/*
 * Decompiled with CFR 0.152.
 */
package cn.wizzer.app.web.modules.controllers.platform.wx;

import cn.wizzer.app.web.commons.ext.wx.WxService;
import cn.wizzer.app.web.commons.slog.annotation.SLog;
import cn.wizzer.app.web.commons.utils.PageUtil;
import cn.wizzer.app.wx.modules.models.Wx_config;
import cn.wizzer.app.wx.modules.models.Wx_user;
import cn.wizzer.app.wx.modules.services.WxConfigService;
import cn.wizzer.app.wx.modules.services.WxUserService;
import cn.wizzer.framework.base.Result;
import com.vdurmont.emoji.EmojiParser;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.json.Json;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.Ok;
import org.nutz.mvc.annotation.Param;
import org.nutz.weixin.spi.WxApi2;
import org.nutz.weixin.spi.WxResp;

@IocBean
@At(value={"/platform/wx/user"})
public class WxUserController {
    private static final Log log = Logs.get();
    @Inject
    private WxUserService wxUserService;
    @Inject
    private WxConfigService wxConfigService;
    @Inject
    private WxService wxService;

    @At(value={"/index", "/index/?"})
    @Ok(value="beetl:/platform/wx/user/index.html")
    @RequiresPermissions(value={"wx.user.list"})
    public void index(String wxid, HttpServletRequest req) {
        Wx_config wxConfig = null;
        List list = this.wxConfigService.query((Condition)Cnd.NEW());
        if (list.size() > 0 && Strings.isBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)list.get(0);
        }
        if (Strings.isNotBlank((CharSequence)wxid)) {
            wxConfig = (Wx_config)this.wxConfigService.fetch(wxid);
        }
        req.setAttribute("wxConfig", wxConfig);
        req.setAttribute("wxList", (Object)list);
    }

    @At
    @Ok(value="json:full")
    @RequiresAuthentication
    public Object data(@Param(value="wxid") String wxid, @Param(value="searchName") String searchName, @Param(value="searchKeyword") String searchKeyword, @Param(value="pageNumber") int pageNumber, @Param(value="pageSize") int pageSize, @Param(value="pageOrderName") String pageOrderName, @Param(value="pageOrderBy") String pageOrderBy) {
        try {
            Cnd cnd = Cnd.NEW();
            if (!Strings.isBlank((CharSequence)wxid)) {
                cnd.and("wxid", "=", (Object)wxid);
            }
            if (Strings.isNotBlank((CharSequence)searchName) && Strings.isNotBlank((CharSequence)searchKeyword)) {
                cnd.and(searchName, "like", (Object)("%" + searchKeyword + "%"));
            }
            if (Strings.isNotBlank((CharSequence)pageOrderName) && Strings.isNotBlank((CharSequence)pageOrderBy)) {
                cnd.orderBy(pageOrderName, PageUtil.getOrder(pageOrderBy));
            }
            return Result.success().addData((Object)this.wxUserService.listPage(pageNumber, pageSize, (Condition)cnd));
        }
        catch (Exception e) {
            return Result.error();
        }
    }

    @At(value={"/down/?"})
    @Ok(value="json")
    @RequiresPermissions(value={"wx.user.list.sync"})
    @SLog(tag="\u540c\u6b65\u5fae\u4fe1\u4f1a\u5458", msg="\u516c\u4f17\u53f7\u552f\u4e00\u6807\u8bc6:${args[0]}")
    public Object down(final String wxid, HttpServletRequest req) {
        try {
            final WxApi2 wxApi2 = this.wxService.getWxApi2(wxid);
            wxApi2.user_get((Each)new Each<String>(){

                public void invoke(int index, String _ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                    WxResp resp = wxApi2.user_info(_ele, "zh_CN");
                    Wx_user usr = (Wx_user)Json.fromJson(Wx_user.class, (CharSequence)Json.toJson((Object)resp.user()));
                    usr.setOpAt(Times.getTS());
                    usr.setNickname(EmojiParser.parseToAliases((String)usr.getNickname(), (EmojiParser.FitzpatrickAction)EmojiParser.FitzpatrickAction.REMOVE));
                    usr.setSubscribeAt(resp.user().getSubscribe_time());
                    usr.setWxid(wxid);
                    if (WxUserController.this.wxUserService.count((Condition)Cnd.where((String)"wxid", (String)"=", (Object)wxid).and("openid", "=", (Object)usr.getOpenid())) == 0) {
                        WxUserController.this.wxUserService.insert(usr);
                    }
                }
            });
            return Result.success();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Result.error();
        }
    }
}

