/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.btree.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class BranchTask<E>
extends Task<E> {
    protected List<Task<E>> children;

    public BranchTask() {
        this.children = new ArrayList<Task<E>>(4);
    }

    public BranchTask(List<Task<E>> children) {
        this.children = Objects.requireNonNull(children);
    }

    public BranchTask(Task<E> first, @Nullable Task<E> second) {
        Objects.requireNonNull(first);
        this.children = new ArrayList<Task<E>>(2);
        this.children.add(first);
        if (second != null) {
            this.children.add(second);
        }
    }

    public final boolean isFirstChild(Task<?> child) {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.get(0) == child;
    }

    public final boolean isLastChild(Task<?> child) {
        if (this.children.isEmpty()) {
            return false;
        }
        return this.children.getLast() == child;
    }

    @Nullable
    public final Task<E> getFirstChild() {
        int size = this.children.size();
        if (size > 0) {
            return this.children.get(0);
        }
        return null;
    }

    @Nullable
    public final Task<E> getLastChild() {
        int size = this.children.size();
        if (size > 0) {
            return this.children.get(size - 1);
        }
        return null;
    }

    public boolean isAllChildCompleted() {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Task<E> child = this.children.get(i);
            if (!child.isRunning()) continue;
            return false;
        }
        return true;
    }

    public final void shuffleChild() {
        Collections.shuffle(this.children);
    }

    @Override
    public final void removeAllChild() {
        this.children.forEach(Task::unsetControl);
        this.children.clear();
    }

    @Override
    public final int indexChild(Task<?> task) {
        return CollectionUtils.indexOfRef(this.children, task, (int)0);
    }

    @Override
    public final Stream<Task<E>> childStream() {
        return this.children.stream();
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final Task<E> getChild(int index) {
        return this.children.get(index);
    }

    @Override
    protected final int addChildImpl(Task<E> task) {
        this.children.add(task);
        return this.children.size() - 1;
    }

    @Override
    protected final Task<E> setChildImpl(int index, Task<E> task) {
        return this.children.set(index, task);
    }

    @Override
    protected final Task<E> removeChildImpl(int index) {
        return this.children.remove(index);
    }

    public List<Task<E>> getChildren() {
        return this.children;
    }

    public void setChildren(List<Task<E>> children) {
        if (children == null) {
            this.children.clear();
        } else {
            this.children = children;
        }
    }
}

