/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.base.collection.SmallArrayList;
import cn.wjybxx.btree.Task;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class CancelToken {
    private int cancelCode;
    private final List<Listener> listeners = new SmallArrayList();

    public CancelToken() {
    }

    public CancelToken(int cancelCode) {
        if (cancelCode < 0) {
            throw new IllegalArgumentException("code: " + cancelCode);
        }
        this.cancelCode = cancelCode;
    }

    public boolean isCancelling() {
        return this.cancelCode > 0;
    }

    public int getCancelCode() {
        return this.cancelCode;
    }

    public void cancel() {
        this.cancel(1);
    }

    public int cancel(int cancelCode) {
        if (cancelCode <= 0) {
            throw new IllegalArgumentException();
        }
        int r = this.cancelCode;
        if (r == 0) {
            this.cancelCode = cancelCode;
            this.notifyListeners();
        }
        return r;
    }

    public CancelToken newChild() {
        CancelToken child = new CancelToken(this.cancelCode);
        if (this.cancelCode <= 0) {
            this.listeners.add(new SubTokenListener(child));
        }
        return child;
    }

    public int addChild(CancelToken child) {
        Objects.requireNonNull(child, "child");
        if (child == this) {
            throw new IllegalArgumentException();
        }
        if (this.cancelCode > 0) {
            child.cancel(this.cancelCode);
            return 0;
        }
        SubTokenListener listener = new SubTokenListener(child);
        this.listeners.add(listener);
        return listener.id;
    }

    public boolean removeChild(CancelToken child) {
        if (child == null) {
            return false;
        }
        return this.removeByHandle(child);
    }

    public void clear() {
        this.cancelCode = 0;
        this.listeners.clear();
    }

    public int addListener(Consumer<? super CancelToken> action) {
        Objects.requireNonNull(action, "action");
        if (this.cancelCode > 0) {
            try {
                action.accept(this);
            }
            catch (AssertionError | Exception e) {
                this.logListenerException(action, (Throwable)e);
            }
            return 0;
        }
        ActionListener listener = new ActionListener(action);
        this.listeners.add(listener);
        return listener.id;
    }

    public boolean removeListener(Consumer<? super CancelToken> action) {
        if (action == null) {
            return false;
        }
        return this.removeByHandle(action);
    }

    public int addListener(Task<?> task) {
        assert (task.isRunning());
        Objects.requireNonNull(task, "task");
        if (this.cancelCode > 0) {
            try {
                task.onCancelRequested(this);
            }
            catch (AssertionError | Exception e) {
                this.logListenerException(task, (Throwable)e);
            }
            return 0;
        }
        TaskListener wrapper = new TaskListener(task);
        this.listeners.add(wrapper);
        return wrapper.id;
    }

    public boolean removeListener(Task<?> task) {
        if (task == null) {
            return false;
        }
        return this.removeByHandle(task);
    }

    public boolean removeById(int listenerId) {
        if (listenerId <= 0) {
            return false;
        }
        List<Listener> listeners = this.listeners;
        for (int idx = listeners.size() - 1; idx >= 0; --idx) {
            Listener wrapper = listeners.get(idx);
            if (wrapper.id != listenerId) continue;
            listeners.remove(idx);
            return true;
        }
        return false;
    }

    private boolean removeByHandle(Object handle) {
        List<Listener> listeners = this.listeners;
        for (int idx = listeners.size() - 1; idx >= 0; --idx) {
            Listener wrapper = listeners.get(idx);
            if (!handle.equals(wrapper.getHandle())) continue;
            listeners.remove(idx);
            return true;
        }
        return false;
    }

    private void notifyListeners() {
        List<Listener> listeners = this.listeners;
        if (listeners.isEmpty()) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            Listener wrapper = listeners.get(i);
            try {
                wrapper.fire(this);
                continue;
            }
            catch (AssertionError | Exception e) {
                this.logListenerException(wrapper.getHandle(), (Throwable)e);
            }
        }
        listeners.clear();
    }

    private void logListenerException(Object action, Throwable e) {
        Task.logger.warn("action caught exception, actionType: " + String.valueOf(action.getClass()), e);
    }

    private static class SubTokenListener
    extends Listener {
        final CancelToken cancelToken;

        private SubTokenListener(CancelToken cancelToken) {
            this.cancelToken = cancelToken;
        }

        @Override
        void fire(CancelToken token) throws Exception {
            this.cancelToken.cancel(token.cancelCode);
        }

        @Override
        Object getHandle() {
            return this.cancelToken;
        }
    }

    private static class ActionListener
    extends Listener {
        final Consumer<? super CancelToken> action;

        private ActionListener(Consumer<? super CancelToken> action) {
            this.action = action;
        }

        @Override
        void fire(CancelToken token) throws Exception {
            this.action.accept(token);
        }

        @Override
        public Object getHandle() {
            return this.action;
        }
    }

    private static abstract class Listener {
        final int id = Listener.nextId();
        private static int idSeq = 0;

        private Listener() {
        }

        abstract void fire(CancelToken var1) throws Exception;

        abstract Object getHandle();

        private static int nextId() {
            int r;
            if ((r = ++idSeq) < 0) {
                idSeq = 1;
                r = 1;
            }
            return r;
        }
    }

    private static class TaskListener
    extends Listener {
        final Task<?> task;
        final int rid;

        public TaskListener(Task<?> task) {
            this.task = task;
            this.rid = task.getReentryId();
        }

        @Override
        void fire(CancelToken token) throws Exception {
            if (!this.task.isExited(this.rid)) {
                this.task.onCancelRequested(token);
            }
        }

        @Override
        Object getHandle() {
            return this.task;
        }
    }
}

