/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Decorator<E>
extends Task<E> {
    protected Task<E> child;

    public Decorator() {
    }

    public Decorator(Task<E> child) {
        this.child = child;
    }

    @Override
    protected void stopRunningChildren() {
        Task.stop(this.child);
    }

    @Override
    protected void onChildRunning(Task<E> child) {
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        if (this.child != null) {
            this.child.onEvent(event);
        }
    }

    @Override
    public final int indexChild(Task<?> task) {
        if (task != null && task == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public final Stream<Task<E>> childStream() {
        return Stream.ofNullable(this.child);
    }

    @Override
    public final int getChildCount() {
        return this.child == null ? 0 : 1;
    }

    @Override
    public final Task<E> getChild(int index) {
        if (index == 0 && this.child != null) {
            return this.child;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final int addChildImpl(Task<E> task) {
        if (this.child != null) {
            throw new IllegalStateException("A task entry cannot have more than one child");
        }
        this.child = task;
        return 0;
    }

    @Override
    protected final Task<E> setChildImpl(int index, Task<E> task) {
        if (index == 0 && this.child != null) {
            Task<E> r = this.child;
            this.child = task;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final Task<E> removeChildImpl(int index) {
        if (index == 0 && this.child != null) {
            Task<E> r = this.child;
            this.child = null;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    public Task<E> getChild() {
        return this.child;
    }

    public void setChild(Task<E> child) {
        this.child = child;
    }
}

