/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.CancelToken;
import cn.wjybxx.btree.TaskEntry;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task<E> {
    public static final Logger logger = LoggerFactory.getLogger(Task.class);
    private static final int MASK_PREV_STATUS = 63;
    private static final int MASK_ENTER_EXECUTE = 64;
    private static final int MASK_STOP_EXIT = 128;
    private static final int MASK_STILLBORN = 256;
    private static final int MASK_EXECUTING = 512;
    private static final int MASK_RUNNING_FIRED = 1024;
    private static final int MASK_DISABLE_NOTIFY = 2048;
    private static final int MASK_INHERITED_BLACKBOARD = 4096;
    private static final int MASK_INHERITED_CANCEL_TOKEN = 8192;
    private static final int MASK_INHERITED_PROPS = 16384;
    private static final int MASK_LOCK1 = 0x100000;
    private static final int MASK_LOCK2 = 0x200000;
    private static final int MASK_LOCK3 = 0x400000;
    private static final int MASK_LOCK4 = 0x800000;
    private static final int MASK_LOCK_ALL = 0xF00000;
    public static final int MASK_DISABLE_ENTER_EXECUTE = 0x1000000;
    public static final int MASK_DISABLE_DELAY_NOTIFY = 0x2000000;
    public static final int MASK_DISABLE_AUTO_CHECK_CANCEL = 0x4000000;
    public static final int MASK_AUTO_LISTEN_CANCEL = 0x8000000;
    public static final int MASK_AUTO_RESET_CHILDREN = 0x10000000;
    public static final int MASK_CONTROL_FLOW_FLAGS = -16777216;
    transient TaskEntry<E> taskEntry;
    transient Task<E> control;
    protected transient E blackboard;
    protected transient CancelToken cancelToken;
    protected transient Object sharedProps;
    transient Object controlData;
    private transient int status;
    private transient int ctl;
    private transient int enterFrame;
    private transient int exitFrame;
    private transient short reentryId;
    private Task<E> guard;
    protected int flags;

    public final TaskEntry<E> getTaskEntry() {
        return this.taskEntry;
    }

    public final Task<E> getControl() {
        return this.control;
    }

    public final E getBlackboard() {
        return this.blackboard;
    }

    public final void setBlackboard(E blackboard) {
        this.blackboard = blackboard;
    }

    public final CancelToken getCancelToken() {
        return this.cancelToken;
    }

    public final void setCancelToken(CancelToken cancelToken) {
        this.cancelToken = cancelToken;
    }

    public final Object getControlData() {
        return this.controlData;
    }

    public final void setControlData(Object controlData) {
        this.controlData = controlData;
    }

    public final Object getSharedProps() {
        return this.sharedProps;
    }

    public final void setSharedProps(Object sharedProps) {
        this.sharedProps = sharedProps;
    }

    public final boolean isRunning() {
        return this.status == 1;
    }

    public final boolean isCompleted() {
        return this.status >= 2;
    }

    public final boolean isSucceeded() {
        return this.status == 2;
    }

    public final boolean isCancelled() {
        return this.status == 3;
    }

    public final boolean isFailed() {
        return this.status > 3;
    }

    public final boolean isFailedOrCancelled() {
        return this.status >= 3;
    }

    public final int getStatus() {
        return this.status;
    }

    public final int getNormalizedStatus() {
        return Math.min(this.status, 4);
    }

    public final int getPrevStatus() {
        return this.ctl & 0x3F;
    }

    public final int getEnterFrame() {
        return this.enterFrame;
    }

    public void setEnterFrame(int enterFrame) {
        this.enterFrame = enterFrame;
    }

    public final int getExitFrame() {
        return this.exitFrame;
    }

    public void setExitFrame(int exitFrame) {
        this.exitFrame = exitFrame;
    }

    public Object getEntity() {
        if (this.taskEntry == null) {
            throw new IllegalStateException("This task has never run");
        }
        return this.taskEntry.getEntity();
    }

    public int getCurFrame() {
        if (this.taskEntry == null) {
            throw new IllegalStateException("This task has never run");
        }
        return this.taskEntry.getCurFrame();
    }

    public final E getEntryBlackboard() {
        if (this.taskEntry == null) {
            throw new IllegalStateException("This task has never run");
        }
        return this.taskEntry.getBlackboard();
    }

    protected void beforeEnter() {
    }

    protected void enter(int reentryId) {
    }

    protected abstract void execute();

    protected void exit() {
    }

    public final void setSuccess() {
        assert (this.status == 1);
        this.status = 2;
        this.template_exit(0);
        if (Task.checkImmediateNotifyMask(this.ctl) && this.control != null) {
            this.control.onChildCompleted(this);
        }
    }

    public final void setCancelled() {
        this.setCompleted(3, false);
    }

    public final void setFailed(int status) {
        if (status < 4) {
            throw new IllegalArgumentException("status " + status);
        }
        this.setCompleted(status, false);
    }

    public final void setGuardFailed(Task<E> control) {
        assert (this.status != 1);
        if (control != null) {
            this.setControl(control);
        }
        this.setCompleted(5, false);
    }

    public final void setCompleted(int status, boolean fromChild) {
        int prevStatus;
        if (status < 2) {
            throw new IllegalArgumentException();
        }
        if (fromChild && status == 5) {
            status = 4;
        }
        if ((prevStatus = this.status) == 1) {
            if (status == 5) {
                throw new IllegalArgumentException("Running task cant fail with 'GUARD_FAILED'");
            }
            this.status = status;
            this.template_exit(0);
        } else {
            this.ctl &= 0xFFFFFFC0;
            this.ctl |= Math.min(63, prevStatus);
            this.ctl |= 0x100;
            this.status = status;
            this.enterFrame = this.exitFrame;
            this.reentryId = (short)(this.reentryId + 1);
        }
        if (Task.checkImmediateNotifyMask(this.ctl) && this.control != null) {
            this.control.onChildCompleted(this);
        }
    }

    protected abstract void onChildRunning(Task<E> var1);

    protected abstract void onChildCompleted(Task<E> var1);

    public final void onEvent(@Nonnull Object event) {
        if (this.canHandleEvent(event)) {
            this.onEventImpl(event);
        }
    }

    public boolean canHandleEvent(@Nonnull Object event) {
        return this.status == 1;
    }

    protected abstract void onEventImpl(@Nonnull Object var1);

    protected void onCancelRequested(CancelToken cancelToken) {
        if (this.isRunning()) {
            this.setCancelled();
        }
    }

    public final void stop() {
        if (this.status == 1) {
            this.status = 3;
            this.template_exit(128);
        } else if (this.status != 0) {
            this.ctl |= 0x80;
        }
    }

    protected void stopRunningChildren() {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            Task<E> child = this.getChild(idx);
            if (child.status != 1) continue;
            child.stop();
        }
    }

    public void resetForRestart() {
        if (this.status == 0) {
            return;
        }
        if (this.status == 1) {
            this.stop();
        }
        this.resetChildrenForRestart();
        if (this.guard != null) {
            this.guard.resetForRestart();
        }
        if (this != this.taskEntry) {
            this.unsetControl();
        }
        this.status = 0;
        this.ctl = 0;
        this.enterFrame = 0;
        this.exitFrame = 0;
        this.reentryId = (short)(this.reentryId + 1);
    }

    protected void resetChildrenForRestart() {
        for (int idx = this.getChildCount() - 1; idx >= 0; --idx) {
            Task<E> child = this.getChild(idx);
            if (child.status == 0) continue;
            child.resetForRestart();
        }
    }

    protected final boolean isExecuting() {
        return (this.ctl & 0x200) != 0;
    }

    public final boolean checkCancel(int rid) {
        if (rid != this.reentryId) {
            return true;
        }
        if (this.cancelToken.isCancelling()) {
            this.setCancelled();
            return true;
        }
        return false;
    }

    public final boolean isExited(int rid) {
        return rid != this.reentryId;
    }

    public final boolean isReentered(int rid) {
        return rid != this.reentryId && rid + 1 != this.reentryId;
    }

    public final int getReentryId() {
        return this.reentryId;
    }

    public final boolean isStillborn() {
        return (this.ctl & 0x100) != 0;
    }

    public final int getRunFrames() {
        if (this.status == 1) {
            return this.taskEntry.getCurFrame() - this.enterFrame;
        }
        if (this.taskEntry == null) {
            return 0;
        }
        return this.exitFrame - this.enterFrame;
    }

    public final boolean isExecuteTriggeredByEnter() {
        return (this.ctl & 0x40) != 0;
    }

    public final boolean isExitTriggeredByStop() {
        return (this.ctl & 0x80) != 0;
    }

    public final void setAutoCheckCancel(boolean enable) {
        this.setCtlBit(0x4000000, !enable);
    }

    public final boolean isAutoCheckCancel() {
        return (this.ctl & 0x4000000) == 0;
    }

    public final void setAutoListenCancel(boolean enable) {
        this.setCtlBit(0x8000000, enable);
    }

    public final boolean isAutoListenCancel() {
        return (this.ctl & 0x8000000) != 0;
    }

    public final void setDisableEnterExecute(boolean disable) {
        this.setCtlBit(0x1000000, disable);
    }

    public final boolean isDisableEnterExecute() {
        return (this.ctl & 0x1000000) != 0;
    }

    public final void setAutoResetChildren(boolean enable) {
        this.setCtlBit(0x10000000, enable);
    }

    public final boolean isAutoResetChildren() {
        return (this.ctl & 0x10000000) != 0;
    }

    public final void setDisableDelayNotify(boolean disable) {
        this.setCtlBit(0x2000000, disable);
    }

    public final boolean isDisableDelayNotify() {
        return (this.ctl & 0x2000000) != 0;
    }

    private static boolean checkNotifyMask(int ctl) {
        return (ctl & 0x880) == 0;
    }

    private static boolean checkDelayNotifyMask(int ctl) {
        return (ctl & 0x2000880) == 0;
    }

    private static boolean checkImmediateNotifyMask(int ctl) {
        return (ctl & 0x880) == 0 && ((ctl & 0x2000000) != 0 || (ctl & 0x200) == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void template_enterExecute(Task<E> control, int initMask) {
        initMask |= this.flags & 0xFF000000;
        if (control != null) {
            initMask |= this.captureContext(control);
        }
        this.ctl = initMask;
        CancelToken cancelToken = this.cancelToken;
        if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.releaseContext();
            this.setCompleted(3, false);
            return;
        }
        int prevStatus = this.status;
        initMask |= Math.min(63, prevStatus);
        this.ctl = initMask |= 0x240;
        this.status = 1;
        this.enterFrame = this.exitFrame = this.taskEntry.getCurFrame();
        short reentryId = this.reentryId = (short)(this.reentryId + 1);
        try {
            this.beforeEnter();
            if (prevStatus != 0 && this.isAutoResetChildren()) {
                this.resetChildrenForRestart();
            }
            this.enter(reentryId);
            if (this.isExited(reentryId)) {
                if (reentryId + 1 == this.reentryId && Task.checkDelayNotifyMask(this.ctl) && control != null) {
                    control.onChildCompleted(this);
                }
                return;
            }
            if (this.isDisableEnterExecute()) {
                this.checkFireRunningAndCancel(control, cancelToken);
                return;
            }
            if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
                this.setDisableDelayNotify(true);
                this.setCancelled();
                return;
            }
            if (this.isAutoListenCancel()) {
                cancelToken.addListener(this);
            }
            this.execute();
            if (this.isExited(reentryId)) {
                if (reentryId + 1 == this.reentryId && Task.checkDelayNotifyMask(this.ctl) && control != null) {
                    control.onChildCompleted(this);
                }
            } else {
                this.checkFireRunningAndCancel(control, cancelToken);
            }
        }
        finally {
            if (reentryId == this.reentryId || reentryId + 1 == this.reentryId) {
                this.ctl &= 0xFFFFFDBF;
            }
        }
    }

    private void checkFireRunningAndCancel(Task<E> control, CancelToken cancelToken) {
        if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.setDisableDelayNotify(true);
            this.setCancelled();
            return;
        }
        if (Task.checkNotifyMask(this.ctl) && control != null) {
            control.onChildRunning(this);
        }
    }

    public final void template_execute() {
        CancelToken cancelToken = this.cancelToken;
        short reentryId = this.reentryId;
        if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.setDisableDelayNotify(true);
            this.setCancelled();
            return;
        }
        this.ctl |= 0x200;
        try {
            this.execute();
        }
        finally {
            if (reentryId == this.reentryId || reentryId + 1 == this.reentryId) {
                this.ctl &= 0xFFFFFDFF;
            }
        }
        if (this.isExited(reentryId)) {
            if (reentryId + 1 == this.reentryId && Task.checkDelayNotifyMask(this.ctl) && this.control != null) {
                this.control.onChildCompleted(this);
            }
        } else if (cancelToken.isCancelling() && this.isAutoCheckCancel()) {
            this.setDisableDelayNotify(true);
            this.setCancelled();
        }
    }

    private void template_exit(int extraMask) {
        if (extraMask != 0) {
            this.ctl |= extraMask;
        }
        this.exitFrame = this.taskEntry.getCurFrame();
        if (this.isAutoListenCancel()) {
            this.cancelToken.removeListener(this);
        }
        try {
            this.stopRunningChildren();
            this.exit();
        }
        finally {
            this.reentryId = (short)(this.reentryId + 1);
            this.releaseContext();
        }
    }

    public final void template_runChild(Task<E> child) {
        assert (this.isReady()) : "Task is not ready";
        if (child.status == 1) {
            child.template_execute();
        } else if (child.guard == null || this.template_checkGuard(child.guard)) {
            child.template_enterExecute(this, 0);
        } else {
            child.setGuardFailed(this);
        }
    }

    public final void template_runChildDirectly(Task<E> child) {
        assert (this.isReady()) : "Task is not ready";
        if (child.status == 1) {
            child.template_execute();
        } else {
            child.template_enterExecute(this, 0);
        }
    }

    public final void template_runHook(Task<E> hook) {
        assert (this.isReady()) : "Task is not ready";
        if (hook.status == 1) {
            hook.template_execute();
        } else if (hook.guard == null || this.template_checkGuard(hook.guard)) {
            hook.template_enterExecute(this, 2048);
        } else {
            hook.setGuardFailed(this);
        }
    }

    public final void template_runHookDirectly(Task<E> hook) {
        assert (this.isReady()) : "Task is not ready";
        if (hook.status == 1) {
            hook.template_execute();
        } else {
            hook.template_enterExecute(this, 2048);
        }
    }

    public final boolean template_checkGuard(@Nullable Task<E> guard) {
        assert (this.isReady()) : "Task is not ready";
        if (guard == null) {
            return true;
        }
        try {
            if (guard.guard != null && !this.template_checkGuard(guard.guard)) {
                boolean bl = false;
                return bl;
            }
            guard.template_enterExecute(this, 2048);
            switch (guard.getNormalizedStatus()) {
                case 2: {
                    boolean bl = true;
                    return bl;
                }
                case 4: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new IllegalStateException("Illegal guard status '%d'. Guards must either succeed or fail in one step.".formatted(guard.getStatus()));
        }
        finally {
            guard.unsetControl();
        }
    }

    private int captureContext(Task<E> control) {
        this.taskEntry = control.taskEntry;
        this.control = control;
        int r = 0;
        if (this.blackboard == null) {
            this.blackboard = Objects.requireNonNull(control.blackboard);
            r |= 0x1000;
        }
        if (this.cancelToken == null) {
            this.cancelToken = Objects.requireNonNull(control.cancelToken);
            r |= 0x2000;
        }
        if (this.sharedProps == null && control.sharedProps != null) {
            this.sharedProps = control.sharedProps;
            r |= 0x4000;
        }
        return r;
    }

    private void releaseContext() {
        int ctl = this.ctl;
        if ((ctl & 0x1000) != 0) {
            this.blackboard = null;
        }
        if ((ctl & 0x2000) != 0) {
            this.cancelToken = null;
        }
        if ((ctl & 0x4000) != 0) {
            this.sharedProps = null;
        }
    }

    public final void setControl(Task<E> control) {
        assert (control != this);
        if (this == this.taskEntry) {
            throw new Error();
        }
        this.taskEntry = Objects.requireNonNull(control.taskEntry);
        this.control = control;
    }

    public final void unsetControl() {
        if (this == this.taskEntry) {
            throw new Error();
        }
        this.taskEntry = null;
        this.control = null;
        this.blackboard = null;
        this.cancelToken = null;
        this.sharedProps = null;
        this.controlData = null;
    }

    public final Task<E> addChild(Task<E> task) {
        this.checkAddChild(task);
        this.addChildImpl(task);
        return this;
    }

    public final Task<E> setChild(int index, Task<E> newTask) {
        this.checkAddChild(newTask);
        return this.setChildImpl(index, newTask);
    }

    private void checkAddChild(Task<E> child) {
        if (null == child) {
            throw new NullPointerException("child");
        }
        if (child.control != this && (child.taskEntry != null || child.control != null)) {
            throw new IllegalArgumentException("child.control is not null");
        }
        if (this == child) {
            throw new IllegalArgumentException("add self to children");
        }
        assert (!child.isRunning());
    }

    public final boolean removeChild(Task<?> task) {
        if (null == task) {
            throw new NullPointerException("task");
        }
        int index = this.indexChild(task);
        if (index > 0) {
            this.removeChildImpl(index);
            task.unsetControl();
            return true;
        }
        return false;
    }

    public final Task<E> removeChild(int index) {
        Task<E> child = this.removeChildImpl(index);
        child.unsetControl();
        return child;
    }

    public void removeAllChild() {
        int size = this.getChildCount();
        for (int idx = 0; idx < size; ++idx) {
            this.removeChildImpl(idx).unsetControl();
        }
    }

    public int indexChild(Task<?> task) {
        int size = this.getChildCount();
        for (int idx = 0; idx < size; ++idx) {
            if (this.getChild(idx) != task) continue;
            return idx;
        }
        return -1;
    }

    public abstract Stream<Task<E>> childStream();

    public abstract int getChildCount();

    public abstract Task<E> getChild(int var1);

    protected abstract int addChildImpl(Task<E> var1);

    protected abstract Task<E> setChildImpl(int var1, Task<E> var2);

    protected abstract Task<E> removeChildImpl(int var1);

    public final void lock(int lockId) {
        int mask = Task.maskOfLock(lockId);
        if ((mask & this.ctl) != 0) {
            throw new IllegalStateException("Lock reentry is not supported, lock: " + lockId);
        }
        this.ctl |= mask;
    }

    public final boolean tryLock(int lockId) {
        int mask = Task.maskOfLock(lockId);
        if ((mask & this.ctl) != 0) {
            return false;
        }
        this.ctl |= mask;
        return true;
    }

    public final void unlock(int lockId) {
        int mask = Task.maskOfLock(lockId);
        if ((mask & this.ctl) == 0) {
            throw new IllegalStateException("You do not own the lock: " + lockId);
        }
        this.ctl &= ~mask;
    }

    public final boolean isLocked(int lockId) {
        return (this.ctl & Task.maskOfLock(lockId)) != 0;
    }

    private static int maskOfLock(int lockId) {
        return switch (lockId) {
            case 1 -> 0x100000;
            case 2 -> 0x200000;
            case 3 -> 0x400000;
            case 4 -> 0x800000;
            default -> throw new IllegalArgumentException("unsupported lockId: " + lockId);
        };
    }

    public static void stop(@Nullable Task<?> task) {
        if (task != null && task.status == 1) {
            task.stop();
        }
    }

    public static void stopSafely(@Nullable Task<?> task) {
        if (task != null && task.status == 1) {
            try {
                task.stop();
            }
            catch (AssertionError | Exception e) {
                logger.warn("task stop caught exception", (Throwable)e);
            }
        }
    }

    public static void resetForRestart(@Nullable Task<?> task) {
        if (task != null && task.status != 0) {
            task.resetForRestart();
        }
    }

    private boolean isReady() {
        if (this.isRunning()) {
            return true;
        }
        if (this == this.taskEntry) {
            return this.taskEntry.isInited();
        }
        return this.taskEntry != null && this.control != null && this.blackboard != null && this.cancelToken != null;
    }

    private void setCtlBit(int mask, boolean enable) {
        this.ctl = enable ? (this.ctl |= mask) : (this.ctl &= ~mask);
    }

    private boolean getCtlBit(int mask) {
        return (this.ctl & mask) != 0;
    }

    public final Task<E> getGuard() {
        return this.guard;
    }

    public final Task<E> setGuard(Task<E> guard) {
        this.guard = guard;
        return this;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final Task<E> setFlags(int flags) {
        this.flags = flags;
        return this;
    }
}

