/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.CancelToken;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskEntryHandler;
import cn.wjybxx.btree.TreeLoader;
import cn.wjybxx.btree.fsm.StateMachineTask;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class TaskEntry<E>
extends Task<E> {
    private String name;
    private Task<E> rootTask;
    private int type;
    private transient Object entity;
    private transient TreeLoader treeLoader;
    private transient int curFrame;
    private transient TaskEntryHandler<E> handler;

    public TaskEntry() {
        this(null, null, null, null, null);
    }

    public TaskEntry(String name, Task<E> rootTask, E blackboard, Object entity, TreeLoader treeLoader) {
        this.name = name;
        this.rootTask = rootTask;
        this.blackboard = blackboard;
        this.entity = entity;
        this.treeLoader = Objects.requireNonNullElse(treeLoader, TreeLoader.nullLoader());
        this.taskEntry = this;
        this.cancelToken = new CancelToken();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task<E> getRootTask() {
        return this.rootTask;
    }

    public void setRootTask(Task<E> rootTask) {
        this.rootTask = rootTask;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public TreeLoader getTreeLoader() {
        return this.treeLoader;
    }

    public final void setTreeLoader(TreeLoader treeLoader) {
        this.treeLoader = Objects.requireNonNullElse(treeLoader, TreeLoader.nullLoader());
    }

    public TaskEntryHandler<E> getHandler() {
        return this.handler;
    }

    public void setHandler(TaskEntryHandler<E> handler) {
        this.handler = handler;
    }

    public final StateMachineTask<E> getRootStateMachine() {
        Task<E> task = this.rootTask;
        if (task instanceof StateMachineTask) {
            StateMachineTask stateMachine = (StateMachineTask)task;
            return stateMachine;
        }
        throw new IllegalStateException("rootTask is not state machine task");
    }

    public void update(int curFrame) {
        this.curFrame = curFrame;
        if (this.getStatus() == 1) {
            this.template_execute();
        } else {
            assert (this.isInited());
            this.template_enterExecute(null, 0);
        }
    }

    @Override
    protected void execute() {
        this.template_runChild(this.rootTask);
    }

    @Override
    protected void onChildRunning(Task<E> child) {
    }

    @Override
    protected void onChildCompleted(Task<E> child) {
        this.setCompleted(child.getStatus(), true);
        this.cancelToken.clear();
        if (this.handler != null) {
            this.handler.onEntryCompleted(this);
        }
    }

    @Override
    public boolean canHandleEvent(@Nonnull Object event) {
        if (this.isRunning()) {
            return true;
        }
        return this.rootTask != null && this.blackboard != null;
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        this.rootTask.onEvent(event);
    }

    @Override
    public final Object getEntity() {
        return this.entity;
    }

    @Override
    public final int getCurFrame() {
        return this.curFrame;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.cancelToken.clear();
        this.curFrame = 0;
    }

    final boolean isInited() {
        return this.rootTask != null && this.blackboard != null && this.cancelToken != null && this.treeLoader != null;
    }

    @Override
    public final int indexChild(Task<?> task) {
        if (task != null && task == this.rootTask) {
            return 0;
        }
        return -1;
    }

    @Override
    public final Stream<Task<E>> childStream() {
        return Stream.ofNullable(this.rootTask);
    }

    @Override
    public final int getChildCount() {
        return this.rootTask == null ? 0 : 1;
    }

    @Override
    public final Task<E> getChild(int index) {
        if (index == 0 && this.rootTask != null) {
            return this.rootTask;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final int addChildImpl(Task<E> task) {
        if (this.rootTask != null) {
            throw new IllegalStateException("A task entry cannot have more than one child");
        }
        this.rootTask = task;
        return 0;
    }

    @Override
    protected final Task<E> setChildImpl(int index, Task<E> task) {
        if (index == 0 && this.rootTask != null) {
            Task<E> r = this.rootTask;
            this.rootTask = task;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final Task<E> removeChildImpl(int index) {
        if (index == 0 && this.rootTask != null) {
            Task<E> r = this.rootTask;
            this.rootTask = null;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }
}

