/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface TreeLoader {
    @Nullable
    public Object tryLoadObject(String var1);

    default public Object loadObject(String nameOrGuid) {
        Object object = this.tryLoadObject(nameOrGuid);
        if (object == null) {
            throw new IllegalArgumentException("target object is absent, name: " + nameOrGuid);
        }
        return object;
    }

    public List<Object> loadManyFromFile(String var1, boolean var2, @Nullable Predicate<? super IEntry> var3);

    @Nullable
    default public <E> Task<E> tryLoadRootTask(String treeName) {
        Object object = this.tryLoadObject(treeName);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Task)) {
            throw new IllegalArgumentException("target object is not a task, name: " + treeName);
        }
        return (Task)object;
    }

    default public <E> Task<E> loadRootTask(String treeName) {
        Object object = this.tryLoadObject(treeName);
        if (object == null) {
            throw new IllegalArgumentException("target tree is absent, name: " + treeName);
        }
        if (!(object instanceof Task)) {
            throw new IllegalArgumentException("target object is not a task, name: " + treeName);
        }
        return (Task)object;
    }

    default public <E> TaskEntry<E> loadTree(String treeName) {
        Task<E> rootTask = this.loadRootTask(treeName);
        return new TaskEntry<Object>(treeName, rootTask, null, null, this);
    }

    public static TreeLoader nullLoader() {
        return NullLoader.INSTANCE;
    }

    public static class NullLoader
    implements TreeLoader {
        static final NullLoader INSTANCE = new NullLoader();

        @Override
        public Object tryLoadObject(String nameOrGuid) {
            return null;
        }

        @Override
        public List<Object> loadManyFromFile(String fileName, boolean sharable, @Nullable Predicate<? super IEntry> filter) {
            return new ArrayList<Object>();
        }
    }

    public static interface IEntry {
        public String getName();

        public String getGuid();

        public int getFlags();

        public int getType();

        public Object getRoot();
    }
}

