/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch.join;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.Join;
import cn.wjybxx.btree.branch.JoinPolicy;

public class JoinSelectorN<E>
implements JoinPolicy<E> {
    private int required = 1;
    private boolean failFast;

    public JoinSelectorN() {
    }

    public JoinSelectorN(int required) {
        this.required = required;
    }

    @Override
    public void resetForRestart() {
    }

    @Override
    public void beforeEnter(Join<E> join) {
    }

    @Override
    public void enter(Join<E> join) {
        if (this.required <= 0) {
            join.setSuccess();
        } else if (join.getChildCount() == 0) {
            join.setFailed(6);
        } else if (this.checkFailFast(join)) {
            join.setFailed(7);
        }
    }

    @Override
    public void onChildCompleted(Join<E> join, Task<E> child) {
        if (join.getSucceededCount() >= this.required) {
            join.setSuccess();
        } else if (join.isAllChildCompleted() || this.checkFailFast(join)) {
            join.setFailed(4);
        }
    }

    private boolean checkFailFast(Join<E> join) {
        return this.failFast && join.getChildCount() - join.getCompletedCount() < this.required - join.getSucceededCount();
    }

    @Override
    public void onEvent(Join<E> join, Object event) {
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required = required;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }
}

