/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Decorator;

public abstract class LoopDecorator<E>
extends Decorator<E> {
    protected int maxLoopPerFrame = 1;

    public LoopDecorator() {
    }

    public LoopDecorator(int maxLoopPerFrame) {
        this.maxLoopPerFrame = Math.max(0, maxLoopPerFrame);
    }

    @Override
    protected void execute() {
        if (this.maxLoopPerFrame < 1) {
            this.setFailed(4);
            return;
        }
        if (this.maxLoopPerFrame == 1) {
            this.template_runChild(this.child);
            return;
        }
        int reentryId = this.getReentryId();
        for (int _i = this.maxLoopPerFrame - 1; _i >= 0; --_i) {
            this.template_runChild(this.child);
            if (this.checkCancel(reentryId)) {
                return;
            }
            if (!this.child.isRunning()) continue;
            return;
        }
    }

    public int getMaxLoopPerFrame() {
        return this.maxLoopPerFrame;
    }

    public void setMaxLoopPerFrame(int maxLoopPerFrame) {
        this.maxLoopPerFrame = maxLoopPerFrame;
    }
}

