/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.btree.LeafTask;
import cn.wjybxx.btree.Status;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineTask;
import javax.annotation.Nonnull;

public class ChangeStateTask<E>
extends LeafTask<E> {
    private String nextStateGuid;
    private transient Task<E> nextState;
    private Object stateProps;
    private int curStateResult;
    private String machineName;
    private int delayMode;

    public ChangeStateTask() {
    }

    public ChangeStateTask(Task<E> nextState) {
        this.nextState = nextState;
    }

    @Override
    protected void execute() {
        if (this.nextState == null) {
            this.nextState = this.getTaskEntry().getTreeLoader().loadRootTask(this.nextStateGuid);
        }
        if (this.stateProps != null) {
            this.nextState.setSharedProps(this.stateProps);
        }
        StateMachineTask<E> stateMachine = StateMachineTask.findStateMachine(this, this.machineName);
        Task curState = stateMachine.getCurState();
        if (Status.isCompleted(this.curStateResult) && curState != null && !curState.isDisableDelayNotify()) {
            curState.setCompleted(this.curStateResult, false);
        }
        if (!this.isDisableDelayNotify()) {
            this.setSuccess();
            stateMachine.changeState(this.nextState, ChangeStateArgs.PLAIN.withDelayMode(this.delayMode));
        } else {
            int reentryId = this.getReentryId();
            stateMachine.changeState(this.nextState, ChangeStateArgs.PLAIN.withDelayMode(this.delayMode));
            if (!this.isExited(reentryId)) {
                this.setSuccess();
            }
        }
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
    }

    public String getNextStateGuid() {
        return this.nextStateGuid;
    }

    public void setNextStateGuid(String nextStateGuid) {
        this.nextStateGuid = nextStateGuid;
    }

    public Task<E> getNextState() {
        return this.nextState;
    }

    public void setNextState(Task<E> nextState) {
        this.nextState = nextState;
    }

    public Object getStateProps() {
        return this.stateProps;
    }

    public void setStateProps(Object stateProps) {
        this.stateProps = stateProps;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public int getDelayMode() {
        return this.delayMode;
    }

    public void setDelayMode(int delayMode) {
        this.delayMode = delayMode;
    }

    public int getCurStateResult() {
        return this.curStateResult;
    }

    public void setCurStateResult(int curStateResult) {
        this.curStateResult = curStateResult;
    }
}

