/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.collection.BoundedArrayDeque;
import cn.wjybxx.base.collection.DequeOverflowBehavior;
import cn.wjybxx.base.collection.EmptyDequeue;
import cn.wjybxx.btree.Decorator;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineHandler;
import cn.wjybxx.btree.fsm.StateMachineListener;
import java.util.Deque;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StateMachineTask<E>
extends Decorator<E> {
    private String name;
    private int noneChildStatus = 2;
    private Task<E> initState;
    private Object initStateProps;
    private transient Task<E> tempNextState;
    private transient Deque<Task<E>> undoQueue = EmptyDequeue.getInstance();
    private transient Deque<Task<E>> redoQueue = EmptyDequeue.getInstance();
    private transient StateMachineListener<E> listener;
    private transient StateMachineHandler<E> stateMachineHandler;

    public final Task<E> getCurState() {
        return this.child;
    }

    public final Task<E> getTempNextState() {
        return this.tempNextState;
    }

    public final Task<E> discardTempNextState() {
        Task<E> r = this.tempNextState;
        if (r != null) {
            this.tempNextState = null;
        }
        return r;
    }

    public final void cancelCurState(int cancelCode) {
        if (this.child != null && this.child.isRunning()) {
            this.child.getCancelToken().cancel(cancelCode);
        }
    }

    public final Task<E> peekUndoState() {
        return this.undoQueue.peekLast();
    }

    public final Task<E> peekRedoState() {
        return this.redoQueue.peekFirst();
    }

    public final Deque<Task<E>> getUndoQueue() {
        return this.undoQueue;
    }

    public final Deque<Task<E>> getRedoQueue() {
        return this.redoQueue;
    }

    public final Deque<Task<E>> setUndoQueueSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize: " + maxSize);
        }
        this.undoQueue = StateMachineTask.setQueueMaxSize(this.undoQueue, maxSize, DequeOverflowBehavior.DISCARD_HEAD);
        return this.undoQueue;
    }

    public final Deque<Task<E>> setRedoQueueSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxSize: " + maxSize);
        }
        this.redoQueue = StateMachineTask.setQueueMaxSize(this.redoQueue, maxSize, DequeOverflowBehavior.DISCARD_TAIL);
        return this.redoQueue;
    }

    private static <E> Deque<E> setQueueMaxSize(Deque<E> queue, int maxSize, DequeOverflowBehavior overflowBehavior) {
        if (maxSize == 0) {
            queue.clear();
            return EmptyDequeue.getInstance();
        }
        if (queue == EmptyDequeue.INSTANCE) {
            return new BoundedArrayDeque(maxSize, overflowBehavior);
        }
        BoundedArrayDeque boundedArrayDeque = (BoundedArrayDeque)queue;
        boundedArrayDeque.setCapacity(maxSize, overflowBehavior);
        return queue;
    }

    public final boolean undoChangeState() {
        return this.undoChangeState(ChangeStateArgs.UNDO);
    }

    public final boolean undoChangeState(ChangeStateArgs changeStateArgs) {
        if (!changeStateArgs.isUndo()) {
            throw new IllegalArgumentException();
        }
        Task<E> prevState = this.undoQueue.peekLast();
        if (prevState == null) {
            return false;
        }
        this.changeState(prevState, changeStateArgs);
        return true;
    }

    public final boolean redoChangeState() {
        return this.redoChangeState(ChangeStateArgs.REDO);
    }

    public final boolean redoChangeState(ChangeStateArgs changeStateArgs) {
        if (!changeStateArgs.isRedo()) {
            throw new IllegalArgumentException();
        }
        Task<E> nextState = this.redoQueue.peekFirst();
        if (nextState == null) {
            return false;
        }
        this.changeState(nextState, changeStateArgs);
        return true;
    }

    public final void changeState(Task<E> nextState) {
        this.changeState(nextState, ChangeStateArgs.PLAIN);
    }

    public void changeState(Task<E> nextState, ChangeStateArgs changeStateArgs) {
        Objects.requireNonNull(nextState, "nextState");
        Objects.requireNonNull(changeStateArgs, "changeStateArgs");
        changeStateArgs = this.checkArgs(changeStateArgs);
        nextState.setControlData(changeStateArgs);
        this.tempNextState = nextState;
        if (!this.isRunning()) {
            return;
        }
        if (changeStateArgs.delayMode == 0) {
            if (this.isExecuting()) {
                this.execute();
            } else {
                this.template_execute();
            }
        }
    }

    protected final ChangeStateArgs checkArgs(ChangeStateArgs changeStateArgs) {
        if (!this.isRunning()) {
            if (changeStateArgs.delayMode == 2) {
                throw new IllegalArgumentException("invalid args");
            }
            return changeStateArgs.withDelayMode(0);
        }
        if (changeStateArgs.delayMode == 2 && changeStateArgs.frame < 0) {
            return changeStateArgs.withFrame(this.getCurFrame() + 1);
        }
        return changeStateArgs;
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        if (this.initState != null) {
            this.initState.resetForRestart();
        }
        if (this.child != null) {
            this.removeChild(0);
        }
        this.tempNextState = null;
        this.undoQueue.clear();
        this.redoQueue.clear();
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        if (this.noneChildStatus == 0) {
            this.noneChildStatus = 2;
        }
        if (this.initState != null && this.initStateProps != null) {
            this.initState.setSharedProps(this.initStateProps);
        }
        if (this.tempNextState == null && this.initState != null) {
            this.tempNextState = this.initState;
        }
        if (this.tempNextState != null && this.tempNextState.getControlData() == null) {
            this.tempNextState.setControlData(ChangeStateArgs.PLAIN);
        }
        if (this.child != null) {
            logger.warn("The child of StateMachine is not null");
            this.removeChild(0);
        }
    }

    @Override
    protected void exit() {
        if (this.child != null) {
            this.removeChild(0);
        }
        this.tempNextState = null;
        this.undoQueue.clear();
        this.redoQueue.clear();
        super.exit();
    }

    @Override
    protected void execute() {
        Task curState = this.child;
        Task nextState = this.tempNextState;
        if (nextState != null && this.isReady(curState, nextState)) {
            this.tempNextState = null;
            if (!this.template_checkGuard(nextState.getGuard())) {
                nextState.setGuardFailed(null);
                if (this.stateMachineHandler != null) {
                    this.stateMachineHandler.onNextStateGuardFailed(this, nextState);
                }
            } else {
                if (curState != null) {
                    curState.stop();
                }
                ChangeStateArgs changeStateArgs = (ChangeStateArgs)nextState.getControlData();
                switch (changeStateArgs.cmd) {
                    case 1: {
                        this.undoQueue.pollLast();
                        if (curState == null) break;
                        this.redoQueue.offerFirst(curState);
                        break;
                    }
                    case 2: {
                        this.redoQueue.pollFirst();
                        if (curState == null) break;
                        this.undoQueue.offerLast(curState);
                        break;
                    }
                    default: {
                        this.redoQueue.clear();
                        if (curState == null) break;
                        this.undoQueue.offerLast(curState);
                    }
                }
                this.notifyChangeState(curState, nextState);
                curState = nextState;
                curState.setCancelToken(this.cancelToken.newChild());
                curState.setControlData(null);
                if (this.child != null) {
                    this.setChild(0, curState);
                } else {
                    this.addChild(curState);
                }
            }
        }
        if (curState == null) {
            this.onNoChildRunning();
            return;
        }
        this.template_runChildDirectly(curState);
    }

    @Override
    protected void onChildCompleted(Task<E> child) {
        assert (this.child == child);
        this.cancelToken.removeChild(child.getCancelToken());
        child.getCancelToken().clear();
        child.setCancelToken(null);
        if (this.tempNextState == null) {
            if (this.stateMachineHandler != null && this.stateMachineHandler.onNextStateAbsent(this, child)) {
                return;
            }
            this.undoQueue.offerLast(child);
            this.removeChild(0);
            this.notifyChangeState(child, null);
            this.onNoChildRunning();
        } else {
            ChangeStateArgs changeStateArgs = (ChangeStateArgs)this.tempNextState.getControlData();
            if (changeStateArgs != null) {
                this.tempNextState.setControlData(changeStateArgs.withDelayMode(0));
            }
            if (this.isExecuting()) {
                this.execute();
            } else {
                this.template_execute();
            }
        }
    }

    protected final void onNoChildRunning() {
        if (this.noneChildStatus != 1) {
            this.setCompleted(this.noneChildStatus, false);
        }
    }

    protected final boolean isReady(@Nullable Task<E> curState, Task<?> nextState) {
        if (curState == null) {
            return true;
        }
        ChangeStateArgs changeStateArgs = (ChangeStateArgs)nextState.getControlData();
        if (changeStateArgs.delayMode == 1) {
            return false;
        }
        if (changeStateArgs.delayMode == 2) {
            return this.getCurFrame() >= changeStateArgs.frame;
        }
        return true;
    }

    protected final void notifyChangeState(@Nullable Task<E> curState, @Nullable Task<E> nextState) {
        assert (curState != null || nextState != null);
        if (this.listener != null) {
            this.listener.beforeChangeState(this, curState, nextState);
        }
    }

    public static <E> StateMachineTask<E> findStateMachine(Task<E> task) {
        Task<E> control;
        while ((control = task.getControl()) != null) {
            if (control instanceof StateMachineTask) {
                StateMachineTask stateMachineTask = (StateMachineTask)control;
                return stateMachineTask;
            }
            Task<E> eldestBrother = control.getChild(0);
            if (eldestBrother instanceof StateMachineTask) {
                StateMachineTask stateMachineTask = (StateMachineTask)eldestBrother;
                return stateMachineTask;
            }
            task = control;
        }
        throw new IllegalStateException("cant find stateMachine from controls");
    }

    @Nonnull
    public static <E> StateMachineTask<E> findStateMachine(Task<E> task, String name) {
        Task<E> control;
        if (ObjectUtils.isBlank((CharSequence)name)) {
            return StateMachineTask.findStateMachine(task);
        }
        while ((control = task.getControl()) != null) {
            StateMachineTask<E> stateMachine = StateMachineTask.castAsStateMachine(control, name);
            if (stateMachine != null) {
                return stateMachine;
            }
            int n = control.getChildCount();
            for (int i = 0; i < n; ++i) {
                Task<E> brother = control.getChild(i);
                stateMachine = StateMachineTask.castAsStateMachine(brother, name);
                if (stateMachine == null) continue;
                return stateMachine;
            }
            task = control;
        }
        throw new IllegalStateException("cant find stateMachine from controls and brothers");
    }

    private static <E> StateMachineTask<E> castAsStateMachine(Task<E> task, String name) {
        StateMachineTask stateMachineTask;
        if (task instanceof StateMachineTask && Objects.equals(name, (stateMachineTask = (StateMachineTask)task).getName())) {
            return stateMachineTask;
        }
        return null;
    }

    public Task<E> getInitState() {
        return this.initState;
    }

    public void setInitState(Task<E> initState) {
        this.initState = initState;
    }

    public Object getInitStateProps() {
        return this.initStateProps;
    }

    public void setInitStateProps(Object initStateProps) {
        this.initStateProps = initStateProps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNoneChildStatus() {
        return this.noneChildStatus;
    }

    public void setNoneChildStatus(int noneChildStatus) {
        this.noneChildStatus = noneChildStatus;
    }

    public StateMachineListener<E> getListener() {
        return this.listener;
    }

    public void setListener(StateMachineListener<E> listener) {
        this.listener = listener;
    }

    public StateMachineHandler<E> getStateMachineHandler() {
        return this.stateMachineHandler;
    }

    public void setStateMachineHandler(StateMachineHandler<E> stateMachineHandler) {
        this.stateMachineHandler = stateMachineHandler;
    }
}

