/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Decorator<T>
extends Task<T> {
    protected Task<T> child;

    public Decorator() {
    }

    public Decorator(Task<T> child) {
        this.child = child;
    }

    @Override
    protected void stopRunningChildren() {
        Task.stop(this.child);
    }

    @Override
    protected void onChildRunning(Task<T> child) {
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        if (this.child != null) {
            this.child.onEvent(event);
        }
    }

    @Override
    public final int indexChild(Task<?> task) {
        if (task != null && task == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public final Stream<Task<T>> childStream() {
        return Stream.ofNullable(this.child);
    }

    @Override
    public final int getChildCount() {
        return this.child == null ? 0 : 1;
    }

    @Override
    public final Task<T> getChild(int index) {
        if (index == 0 && this.child != null) {
            return this.child;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final int addChildImpl(Task<T> task) {
        if (this.child != null) {
            throw new IllegalStateException("A task entry cannot have more than one child");
        }
        this.child = task;
        return 0;
    }

    @Override
    protected final Task<T> setChildImpl(int index, Task<T> task) {
        if (index == 0 && this.child != null) {
            Task<T> r = this.child;
            this.child = task;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    protected final Task<T> removeChildImpl(int index) {
        if (index == 0 && this.child != null) {
            Task<T> r = this.child;
            this.child = null;
            return r;
        }
        throw new IndexOutOfBoundsException(index);
    }

    public Task<T> getChild() {
        return this.child;
    }

    public void setChild(Task<T> child) {
        this.child = child;
    }
}

