/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree;

import cn.wjybxx.btree.Task;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class TaskOverrides {
    public static final int MASK_BEFORE_ENTER = 1;
    public static final int MASK_ENTER = 2;
    public static final int MASK_EXIT = 4;
    private static final int MASK_ALL = 15;
    private static final ConcurrentMap<Class<?>, Integer> maskCacheMap = new ConcurrentHashMap(64);

    TaskOverrides() {
    }

    public static int maskOfTask(Class<? extends Task> clazz) {
        Integer cachedMask = (Integer)maskCacheMap.get(clazz);
        if (cachedMask != null) {
            return cachedMask;
        }
        int mask = 15;
        try {
            if (TaskOverrides.getDeclaredMethodInherit(clazz, "beforeEnter") == null) {
                mask &= 0xFFFFFFFE;
            }
            if (TaskOverrides.getDeclaredMethodInherit(clazz, "enter") == null) {
                mask &= 0xFFFFFFFD;
            }
            if (TaskOverrides.getDeclaredMethodInherit(clazz, "exit") == null) {
                mask &= 0xFFFFFFFB;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        maskCacheMap.put(clazz, mask);
        return mask;
    }

    private static Method getDeclaredMethodInherit(Class<?> clazz, String methodName) {
        while (clazz != Task.class) {
            Method targetMethod = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> methodName.equals(method.getName())).findFirst().orElse(null);
            if (targetMethod != null) {
                return targetMethod;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }
}

