/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.branch.JoinPolicy;
import cn.wjybxx.btree.branch.Parallel;
import cn.wjybxx.btree.branch.join.JoinSequence;
import java.util.List;
import javax.annotation.Nonnull;

public class Join<T>
extends Parallel<T> {
    protected JoinPolicy<T> policy;
    protected transient int[] childPrevReentryIds;
    protected transient int completedCount;
    protected transient int succeededCount;

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.completedCount = 0;
        this.succeededCount = 0;
        this.policy.resetForRestart();
    }

    @Override
    protected void beforeEnter() {
        if (this.policy == null) {
            this.policy = JoinSequence.getInstance();
        }
        this.completedCount = 0;
        this.succeededCount = 0;
        this.policy.beforeEnter(this);
    }

    @Override
    protected void enter(int reentryId) {
        this.recordContext();
        this.policy.enter(this);
    }

    private void recordContext() {
        List children = this.children;
        if (this.childPrevReentryIds == null || this.childPrevReentryIds.length != children.size()) {
            this.childPrevReentryIds = new int[children.size()];
        }
        for (int i = 0; i < children.size(); ++i) {
            Task child = (Task)children.get(i);
            child.setCancelToken(this.cancelToken.newChild());
            this.childPrevReentryIds[i] = child.getReentryId();
        }
    }

    @Override
    protected void execute() {
        List children = this.children;
        if (children.isEmpty()) {
            return;
        }
        int[] childPrevReentryIds = this.childPrevReentryIds;
        int reentryId = this.getReentryId();
        for (int i = 0; i < children.size(); ++i) {
            Task child = (Task)children.get(i);
            boolean started = child.isExited(childPrevReentryIds[i]);
            if (started && child.isCompleted()) continue;
            this.template_runChild(child);
            if (!this.checkCancel(reentryId)) continue;
            return;
        }
        if (this.completedCount >= children.size()) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        ++this.completedCount;
        if (child.isSucceeded()) {
            ++this.succeededCount;
        }
        this.cancelToken.unregister((Object)child.getCancelToken());
        child.getCancelToken().reset();
        child.setCancelToken(null);
        this.policy.onChildCompleted(this, child);
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        this.policy.onEvent(this, event);
    }

    @Override
    public boolean isAllChildCompleted() {
        return this.completedCount >= this.children.size();
    }

    public boolean isAllChildSucceeded() {
        return this.succeededCount >= this.children.size();
    }

    public int getCompletedCount() {
        return this.completedCount;
    }

    public int getSucceededCount() {
        return this.succeededCount;
    }

    public JoinPolicy<T> getPolicy() {
        return this.policy;
    }

    public void setPolicy(JoinPolicy<T> policy) {
        this.policy = policy;
    }
}

