/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.branch;

import cn.wjybxx.btree.BranchTask;
import cn.wjybxx.btree.Task;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SingleRunningChildBranch<T>
extends BranchTask<T> {
    protected transient Task<T> runningChild = null;
    protected transient int runningIndex = -1;

    public SingleRunningChildBranch() {
    }

    public SingleRunningChildBranch(List<Task<T>> children) {
        super(children);
    }

    public SingleRunningChildBranch(Task<T> first, @Nullable Task<T> second) {
        super(first, second);
    }

    public final int getRunningIndex() {
        return this.runningIndex;
    }

    public int getCompletedCount() {
        return this.runningIndex + 1;
    }

    @Override
    public boolean isAllChildCompleted() {
        return this.runningIndex + 1 >= this.children.size();
    }

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.runningChild = null;
        this.runningIndex = -1;
    }

    @Override
    protected void beforeEnter() {
        this.runningChild = null;
        this.runningIndex = -1;
    }

    @Override
    protected void exit() {
        this.runningChild = null;
    }

    @Override
    protected void stopRunningChildren() {
        Task.stop(this.runningChild);
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
        if (this.runningChild != null) {
            this.runningChild.onEvent(event);
        }
    }

    @Override
    protected void execute() {
        int reentryId = this.getReentryId();
        Task<T> runningChild = this.runningChild;
        int retryCount = this.children.size();
        for (int i = 0; i < retryCount; ++i) {
            if (runningChild == null) {
                runningChild = this.nextChild();
                this.runningChild = runningChild;
            }
            this.template_runChild(runningChild);
            if (this.checkCancel(reentryId)) {
                return;
            }
            if (runningChild.isRunning()) {
                return;
            }
            runningChild = null;
        }
        throw new IllegalStateException(this.illegalStateMsg());
    }

    protected Task<T> nextChild() {
        int nextIndex = this.runningIndex + 1;
        if (nextIndex < this.children.size()) {
            this.runningIndex = nextIndex;
            return (Task)this.children.get(nextIndex);
        }
        throw new IllegalStateException(this.illegalStateMsg());
    }

    protected final String illegalStateMsg() {
        return "numChildren: %d, currentIndex: %d".formatted(this.children.size(), this.runningIndex);
    }

    @Override
    protected void onChildRunning(Task<T> child) {
        this.runningChild = child;
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        assert (child == this.runningChild);
        this.runningChild = null;
    }
}

