/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.decorator;

import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.decorator.LoopDecorator;

public class Repeat<T>
extends LoopDecorator<T> {
    public static final int MODE_ALWAYS = 0;
    public static final int MODE_ONLY_SUCCESS = 1;
    public static final int MODE_ONLY_FAILED = 2;
    public static final int MODE_NEVER = 3;
    private int countMode = 0;
    private int required = 1;
    private transient int count;

    @Override
    public void resetForRestart() {
        super.resetForRestart();
        this.count = 0;
    }

    @Override
    protected void beforeEnter() {
        super.beforeEnter();
        this.count = 0;
    }

    @Override
    protected void enter(int reentryId) {
        super.enter(reentryId);
        if (this.required < 1) {
            this.setSuccess();
        }
    }

    @Override
    protected void onChildCompleted(Task<T> child) {
        boolean match;
        if (child.isCancelled()) {
            this.setCancelled();
            return;
        }
        switch (this.countMode) {
            case 0: {
                boolean bl = true;
                break;
            }
            case 1: {
                boolean bl = child.isSucceeded();
                break;
            }
            case 2: {
                boolean bl = child.isFailed();
                break;
            }
            default: {
                boolean bl = match = false;
            }
        }
        if (match && ++this.count >= this.required) {
            this.setSuccess();
        }
    }

    public int getCountMode() {
        return this.countMode;
    }

    public void setCountMode(int countMode) {
        this.countMode = countMode;
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        this.required = required;
    }
}

