/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

public final class ChangeStateArgs {
    public static final int CMD_NONE = 0;
    public static final int CMD_UNDO = 1;
    public static final int CMD_REDO = 2;
    public static final int DELAY_NONE = 0;
    public static final int DELAY_CURRENT_COMPLETED = 1;
    public static final int DELAY_NEXT_FRAME = 2;
    public static final ChangeStateArgs PLAIN = new ChangeStateArgs(0, 0, 0, null);
    public static final ChangeStateArgs PLAIN_WHEN_COMPLETED = new ChangeStateArgs(0, 1, 0, null);
    public static final ChangeStateArgs PLAIN_NEXT_FRAME = new ChangeStateArgs(0, 2, -1, null);
    public static final ChangeStateArgs UNDO = new ChangeStateArgs(1, 0, 0, null);
    public static final ChangeStateArgs UNDO_WHEN_COMPLETED = new ChangeStateArgs(1, 1, 0, null);
    public static final ChangeStateArgs UNDO_NEXT_FRAME = new ChangeStateArgs(1, 2, -1, null);
    public static final ChangeStateArgs REDO = new ChangeStateArgs(2, 0, 0, null);
    public static final ChangeStateArgs REDO_WHEN_COMPLETED = new ChangeStateArgs(2, 1, 0, null);
    public static final ChangeStateArgs REDO_NEXT_FRAME = new ChangeStateArgs(2, 2, -1, null);
    public final int cmd;
    public final int delayMode;
    public final int frame;
    public final Object extraInfo;

    private ChangeStateArgs(int cmd, int delayMode, int frame, Object extraInfo) {
        ChangeStateArgs.checkDelayMode(delayMode);
        this.delayMode = delayMode;
        this.cmd = cmd;
        this.frame = frame;
        this.extraInfo = extraInfo;
    }

    public final boolean isPlain() {
        return this.cmd == 0;
    }

    public final boolean isUndo() {
        return this.cmd == 1;
    }

    public final boolean isRedo() {
        return this.cmd == 2;
    }

    public ChangeStateArgs withDelayMode(int delayMode) {
        if (delayMode == this.delayMode) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, delayMode, this.frame, this.extraInfo);
    }

    public ChangeStateArgs withFrame(int frame) {
        if (frame == this.frame) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, this.delayMode, frame, this.extraInfo);
    }

    public ChangeStateArgs withExtraInfo(Object extraInfo) {
        if (extraInfo == this.extraInfo) {
            return this;
        }
        return new ChangeStateArgs(this.cmd, this.delayMode, this.frame, extraInfo);
    }

    private static void checkCmd(int cmd) {
        if (cmd < 0 || cmd > 2) {
            throw new IllegalArgumentException("cmd: " + cmd);
        }
    }

    private static void checkDelayMode(int delayMode) {
        if (delayMode < 0 || delayMode > 2) {
            throw new IllegalArgumentException("invalid delayMode: " + delayMode);
        }
    }
}

