/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.btree.fsm;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.btree.LeafTask;
import cn.wjybxx.btree.Task;
import cn.wjybxx.btree.TaskStatus;
import cn.wjybxx.btree.fsm.ChangeStateArgs;
import cn.wjybxx.btree.fsm.StateMachineTask;
import javax.annotation.Nonnull;

public class ChangeStateTask<T>
extends LeafTask<T> {
    private String nextStateGuid;
    private transient Task<T> nextState;
    private Object stateProps;
    private int curStateResult;
    private String machineName;
    private int delayMode;

    public ChangeStateTask() {
    }

    public ChangeStateTask(Task<T> nextState) {
        this.nextState = nextState;
    }

    @Override
    protected void execute() {
        if (this.nextState == null) {
            if (ObjectUtils.isEmpty((CharSequence)this.nextStateGuid)) {
                throw new IllegalStateException("guid is empty");
            }
            this.nextState = this.getTaskEntry().getTreeLoader().loadRootTask(this.nextStateGuid);
        }
        if (this.stateProps != null) {
            this.nextState.setSharedProps(this.stateProps);
        }
        StateMachineTask<T> stateMachine = StateMachineTask.findStateMachine(this, this.machineName);
        Task curState = stateMachine.getCurState();
        if (TaskStatus.isCompleted(this.curStateResult) && curState != null && !curState.isDisableDelayNotify()) {
            curState.setCompleted(this.curStateResult, false);
        }
        if (!this.isDisableDelayNotify()) {
            this.setSuccess();
            stateMachine.changeState(this.nextState, ChangeStateArgs.PLAIN.withDelayMode(this.delayMode));
        } else {
            int reentryId = this.getReentryId();
            stateMachine.changeState(this.nextState, ChangeStateArgs.PLAIN.withDelayMode(this.delayMode));
            if (!this.isExited(reentryId)) {
                this.setSuccess();
            }
        }
    }

    @Override
    protected void onEventImpl(@Nonnull Object event) {
    }

    public String getNextStateGuid() {
        return this.nextStateGuid;
    }

    public void setNextStateGuid(String nextStateGuid) {
        this.nextStateGuid = nextStateGuid;
    }

    public Task<T> getNextState() {
        return this.nextState;
    }

    public void setNextState(Task<T> nextState) {
        this.nextState = nextState;
    }

    public Object getStateProps() {
        return this.stateProps;
    }

    public void setStateProps(Object stateProps) {
        this.stateProps = stateProps;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public int getDelayMode() {
        return this.delayMode;
    }

    public void setDelayMode(int delayMode) {
        this.delayMode = delayMode;
    }

    public int getCurStateResult() {
        return this.curStateResult;
    }

    public void setCurStateResult(int curStateResult) {
        this.curStateResult = curStateResult;
    }
}

