/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.PropertiesUtils;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Properties;

public class LocalByteArrayPool
implements ObjectPool<byte[]> {
    public static final LocalByteArrayPool INSTANCE = new LocalByteArrayPool();
    private static final int BUFFER_SIZE;
    private static final int POOL_SIZE;
    private static final ThreadLocal<ArrayDeque<byte[]>> LOCAL_BUFFER_QUEUE;

    @Override
    public byte[] rent() {
        byte[] buffer = LOCAL_BUFFER_QUEUE.get().pollLast();
        if (buffer != null) {
            return buffer;
        }
        return new byte[BUFFER_SIZE];
    }

    @Override
    public void returnOne(byte[] buffer) {
        Objects.requireNonNull(buffer, "buffer");
        ArrayDeque<byte[]> queue = LOCAL_BUFFER_QUEUE.get();
        if (queue.size() < POOL_SIZE) {
            queue.addLast(buffer);
        }
    }

    @Override
    public void clear() {
    }

    static {
        Properties properties = System.getProperties();
        BUFFER_SIZE = PropertiesUtils.getInt(properties, "cn.wjybxx.base.io.buffer_size", 65536);
        POOL_SIZE = PropertiesUtils.getInt(properties, "cn.wjybxx.base.io.buffer_poolsize", 4);
        LOCAL_BUFFER_QUEUE = ThreadLocal.withInitial(() -> new ArrayDeque(POOL_SIZE));
    }
}

