/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import cn.wjybxx.base.time.TimeUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TimeHelper {
    private static final TimeHelper CST = new TimeHelper(TimeUtils.ZONE_OFFSET_CST);
    private static final TimeHelper UTC = new TimeHelper(TimeUtils.ZONE_OFFSET_UTC);
    public static final TimeHelper SYSTEM = new TimeHelper(TimeUtils.ZONE_OFFSET_SYSTEM);
    private final ZoneOffset zoneOffset;

    private TimeHelper(ZoneOffset zoneOffset) {
        this.zoneOffset = zoneOffset;
    }

    public static TimeHelper of(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(TimeHelper.CST.zoneOffset)) {
            return CST;
        }
        if (zoneOffset.equals(TimeHelper.SYSTEM.zoneOffset)) {
            return SYSTEM;
        }
        if (zoneOffset.equals(TimeHelper.UTC.zoneOffset)) {
            return UTC;
        }
        return new TimeHelper(zoneOffset);
    }

    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    public long getOffsetSeconds() {
        return this.zoneOffset.getTotalSeconds();
    }

    public long getOffsetMillis() {
        return (long)this.zoneOffset.getTotalSeconds() * 1000L;
    }

    public long toEpochMillis(LocalDateTime localDateTime) {
        long millis = (long)localDateTime.getNano() / 1000000L;
        return localDateTime.toEpochSecond(this.zoneOffset) * 1000L + millis;
    }

    public int toLocalEpochDay(long epochMilli) {
        long localSecond = epochMilli / 1000L + (long)this.zoneOffset.getTotalSeconds();
        long localEpochDay = Math.floorDiv(localSecond, 86400);
        return Math.toIntExact(localEpochDay);
    }

    public LocalDateTime toLocalDateTime(long epochMilli) {
        long extraMilli = epochMilli % 1000L;
        int nanoOfSecond = (int)(extraMilli * 1000000L);
        return LocalDateTime.ofEpochSecond(epochMilli / 1000L, nanoOfSecond, this.zoneOffset);
    }

    public LocalDateTime toLocalDateTimeIgnoreMs(long epochMilli) {
        return LocalDateTime.ofEpochSecond(epochMilli / 1000L, 0, this.zoneOffset);
    }

    public String formatTime(long epochMilli) {
        return this.formatTime(epochMilli, TimeUtils.DEFAULT_FORMATTER);
    }

    public String formatTime(long epochMilli, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = this.toLocalDateTime(epochMilli);
        return formatter.format(localDateTime);
    }

    public long parseTimeMillis(String dateString) {
        return this.toEpochMillis(LocalDateTime.parse(dateString, TimeUtils.DEFAULT_FORMATTER));
    }

    public long parseTimeMillis(String dateString, DateTimeFormatter formatter) {
        return this.toEpochMillis(LocalDateTime.parse(dateString, formatter));
    }

    public long getTimeHourOfToday(long epochMilli, int hour) {
        LocalDateTime localDateTime = this.toLocalDateTimeIgnoreMs(epochMilli).with(LocalTime.of(hour, 0));
        return this.toEpochMillis(localDateTime);
    }

    public long getTimeBeginOfToday(long epochMilli) {
        LocalDateTime localDateTime = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY);
        return this.toEpochMillis(localDateTime);
    }

    public long getTimeEndOfToday(long epochMilli) {
        LocalDateTime localDateTime = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY);
        return this.toEpochMillis(localDateTime);
    }

    public long getTimeBeginOfWeek(long epochMilli) {
        LocalDateTime startOfDay = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY);
        int deltaDay = startOfDay.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue();
        return this.toEpochMillis(startOfDay) - (long)deltaDay * 86400000L;
    }

    public long getTimeEndOfWeek(long epochMilli) {
        return this.getTimeBeginOfWeek(epochMilli) + 604800000L - 1L;
    }

    public long getTimeBeginOfMonth(long epochMilli) {
        LocalDateTime firstDayOfMonth = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY).withDayOfMonth(1);
        return this.toEpochMillis(firstDayOfMonth);
    }

    public long getTimeEndOfMonth(long epochMilli) {
        LocalDateTime endOfDay = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY);
        LocalDateTime lastDayOfMonth = endOfDay.withDayOfMonth(TimeUtils.lengthOfMonth(endOfDay));
        return this.toEpochMillis(lastDayOfMonth);
    }

    public long getTimeBeginOfMonth(long epochMilli, int deltaMonth) {
        LocalDateTime firstDayOfNextMonth = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.START_OF_DAY).withDayOfMonth(1).plusMonths(deltaMonth);
        return this.toEpochMillis(firstDayOfNextMonth);
    }

    public long getTimeEndOfMonth(long epochMilli, int deltaMonth) {
        LocalDateTime firstDayOfNextMonth = this.toLocalDateTimeIgnoreMs(epochMilli).with(TimeUtils.END_OF_DAY).withDayOfMonth(1).plusMonths(deltaMonth);
        LocalDateTime lastDayOfMonth = firstDayOfNextMonth.withDayOfMonth(TimeUtils.lengthOfMonth(firstDayOfNextMonth));
        return this.toEpochMillis(lastDayOfMonth);
    }

    public boolean isSameDay(long time1, long time2) {
        return this.toLocalEpochDay(time1) == this.toLocalEpochDay(time2);
    }

    public int differDays(long time1, long time2) {
        return Math.abs(this.toLocalEpochDay(time1) - this.toLocalEpochDay(time2));
    }

    public boolean isSameWeek(long time1, long time2) {
        return this.getTimeBeginOfWeek(time1) == this.getTimeBeginOfWeek(time2);
    }

    public int differWeeks(long time1, long time2) {
        long deltaTime = this.getTimeBeginOfWeek(time1) - this.getTimeBeginOfWeek(time2);
        return (int)Math.abs(deltaTime / 604800000L);
    }

    public String toString(LocalDateTime localDateTime) {
        return TimeHelper.toString(localDateTime.toLocalDate()) + "T" + TimeHelper.toString(localDateTime.toLocalTime()) + this.zoneOffset.toString();
    }

    public static String toString(LocalDate localDate) {
        return localDate.toString();
    }

    public static String toString(LocalTime localTime) {
        int hourValue = localTime.getHour();
        int minuteValue = localTime.getMinute();
        int secondValue = localTime.getSecond();
        int nanoValue = localTime.getNano();
        StringBuilder buf = new StringBuilder(18).append(hourValue < 10 ? "0" : "").append(hourValue).append(minuteValue < 10 ? ":0" : ":").append(minuteValue).append(secondValue < 10 ? ":0" : ":").append(secondValue);
        int milliValue = (int)((long)nanoValue / 1000000L);
        if (milliValue > 0) {
            buf.append('.');
            if (milliValue < 10) {
                buf.append("00").append(milliValue);
            } else if (milliValue < 100) {
                buf.append("0").append(milliValue);
            } else {
                buf.append(milliValue);
            }
        }
        return buf.toString();
    }

    public static String toString(ZoneOffset zoneOffset) {
        int totalSeconds = zoneOffset.getTotalSeconds();
        if (totalSeconds == 0) {
            return "Z";
        }
        int absTotalSeconds = Math.abs(totalSeconds);
        int absHours = absTotalSeconds / 3600;
        int absMinutes = absTotalSeconds / 60 % 60;
        StringBuilder buf = new StringBuilder().append(totalSeconds < 0 ? "-" : "+").append(absHours < 10 ? "0" : "").append(absHours).append(absMinutes < 10 ? ":0" : ":").append(absMinutes);
        return buf.toString();
    }
}

