/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.base.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesUtils {
    public static String getString(Properties properties, String key) {
        return properties.getProperty(key);
    }

    public static String getString(Properties properties, String key, String def) {
        return properties.getProperty(key, def);
    }

    public static int getInt(Properties properties, String key) {
        return PropertiesUtils.getInt(properties, key, 0);
    }

    public static int getInt(Properties properties, String key, int def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static long getLong(Properties properties, String key) {
        return PropertiesUtils.getLong(properties, key, 0L);
    }

    public static long getLong(Properties properties, String key, long def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static float getFloat(Properties properties, String key) {
        return PropertiesUtils.getFloat(properties, key, 0.0f);
    }

    public static float getFloat(Properties properties, String key, float def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Float.parseFloat(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static double getDouble(Properties properties, String key) {
        return PropertiesUtils.getDouble(properties, key, 0.0);
    }

    public static double getDouble(Properties properties, String key, double def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static short getShort(Properties properties, String key) {
        return PropertiesUtils.getShort(properties, key, (short)0);
    }

    public static short getShort(Properties properties, String key, short def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        try {
            return Short.parseShort(v);
        }
        catch (NumberFormatException ignore) {
            return def;
        }
    }

    public static boolean getBool(Properties properties, String key) {
        return PropertiesUtils.getBool(properties, key, false);
    }

    public static boolean getBool(Properties properties, String key, boolean def) {
        String v = properties.getProperty(key);
        if (ObjectUtils.isEmpty(v)) {
            return def;
        }
        return PropertiesUtils.toBoolean(v, def);
    }

    public static boolean toBoolean(String value, boolean def) {
        if (value == null || value.isEmpty()) {
            return def;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return def;
        }
        return switch (value) {
            case "true", "yes", "y", "1" -> true;
            case "false", "no", "n", "0" -> false;
            default -> def;
        };
    }

    public static Map<String, String> toMap(Properties properties) {
        Set<String> keySet = properties.stringPropertyNames();
        HashMap<String, String> hashMap = CollectionUtils.newHashMap(keySet.size());
        for (String key : keySet) {
            String value = properties.getProperty(key);
            if (value == null) continue;
            hashMap.put(key, value);
        }
        return hashMap;
    }
}

