/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.PropertiesUtils;
import cn.wjybxx.base.io.SimpleByteArrayPool;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.Properties;

public class LocalByteArrayPool
implements ObjectPool<byte[]> {
    public static final LocalByteArrayPool INSTANCE = new LocalByteArrayPool();
    private static final int POOL_SIZE;
    private static final int BUFFER_SIZE;
    private static final ThreadLocal<SimpleByteArrayPool> THREAD_LOCAL_INST;

    @Override
    public byte[] rent() {
        return THREAD_LOCAL_INST.get().rent();
    }

    @Override
    public void returnOne(byte[] buffer) {
        THREAD_LOCAL_INST.get().returnOne(buffer);
    }

    @Override
    public void clear() {
    }

    public static SimpleByteArrayPool localInst() {
        return THREAD_LOCAL_INST.get();
    }

    static {
        Properties properties = System.getProperties();
        POOL_SIZE = PropertiesUtils.getInt(properties, "Wjybxx.Commons.IO.LocalByteArrayPool.PoolSize", 4);
        BUFFER_SIZE = PropertiesUtils.getInt(properties, "Wjybxx.Commons.IO.LocalByteArrayPool.BufferSize", 65536);
        THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new SimpleByteArrayPool(POOL_SIZE, BUFFER_SIZE));
    }
}

