/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.MathCommon;
import cn.wjybxx.base.pool.ObjectPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleByteArrayPool
implements ObjectPool<byte[]> {
    private final int poolSize;
    private final int bufferSize;
    private final boolean clear;
    private final List<byte[]> freeBuffers;

    public SimpleByteArrayPool(int poolSize, int bufferSize) {
        this(poolSize, bufferSize, false);
    }

    public SimpleByteArrayPool(int poolSize, int bufferSize, boolean clear) {
        if (poolSize < 0 || bufferSize < 0) {
            throw new IllegalArgumentException();
        }
        this.poolSize = poolSize;
        this.bufferSize = bufferSize;
        this.clear = clear;
        this.freeBuffers = new ArrayList<byte[]>(MathCommon.clamp(poolSize, 0, 10));
    }

    @Override
    @Nonnull
    public byte[] rent() {
        int size = this.freeBuffers.size();
        if (size > 0) {
            return this.freeBuffers.remove(size - 1);
        }
        return new byte[this.bufferSize];
    }

    @Override
    public void returnOne(byte[] buffer) {
        Objects.requireNonNull(buffer);
        if (this.freeBuffers.size() < this.poolSize) {
            if (this.clear) {
                Arrays.fill(buffer, (byte)0);
            }
            this.freeBuffers.add(buffer);
        }
    }

    @Override
    public void clear() {
        this.freeBuffers.clear();
    }
}

