/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.time;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final ZoneOffset ZONE_OFFSET_CST = ZoneOffset.ofHours(8);
    public static final ZoneOffset ZONE_OFFSET_UTC = ZoneOffset.UTC;
    public static final ZoneOffset ZONE_OFFSET_SYSTEM = ZoneOffset.systemDefault().getRules().getOffset(LocalDateTime.now());
    public static final long SEC = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int DAYS_PER_WEEK = 7;
    public static final long NANOS_PER_MILLI = 1000000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTES = 60000000000L;
    public static final long NANOS_PER_HOURS = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int SECONDS_PER_WEEK = 604800;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int MINUTES_PER_WEEK = 10080;
    public static final LocalTime START_OF_DAY = LocalTime.MIN;
    public static final LocalTime END_OF_DAY = LocalTime.MAX;
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter HH_MM = DateTimeFormatter.ofPattern("HH:mm");

    private TimeUtils() {
    }

    public static long toEpochMillis(LocalDateTime dateTime) {
        long millis = (long)dateTime.getNano() / 1000000L;
        return dateTime.toEpochSecond(ZoneOffset.UTC) * 1000L + millis;
    }

    public LocalDateTime toDateTime(long epochMilli) {
        long extraMilli = epochMilli % 1000L;
        int nanoOfSecond = (int)(extraMilli * 1000000L);
        return LocalDateTime.ofEpochSecond(epochMilli / 1000L, nanoOfSecond, ZoneOffset.UTC);
    }

    public static long toMillisOfDay(LocalTime time) {
        return (long)time.toSecondOfDay() * 1000L + (long)time.getNano() / 1000000L;
    }

    public static int toSecondOfDay(LocalTime time) {
        return time.toSecondOfDay();
    }

    public static long toMillis(long seconds, long millis) {
        return seconds * 1000L + millis;
    }

    public static int lengthOfMonth(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().lengthOfMonth();
    }

    public static String abbreviate(TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "\u03bcs";
            case TimeUnit.MILLISECONDS -> "ms";
            case TimeUnit.SECONDS -> "s";
            case TimeUnit.MINUTES -> "min";
            case TimeUnit.HOURS -> "h";
            case TimeUnit.DAYS -> "d";
            default -> throw new AssertionError();
        };
    }
}

