/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.base.Preconditions;
import cn.wjybxx.base.collection.DelayedCompressList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    private CollectionUtils() {
    }

    public static <E> DelayedCompressList<E> newDelayedCompressList() {
        return new DelayedCompressList();
    }

    public static <E> DelayedCompressList<E> newDelayedCompressList(int initCapacity) {
        return new DelayedCompressList(initCapacity);
    }

    public static <E> DelayedCompressList<E> newDelayedCompressList(Collection<? extends E> src) {
        return new DelayedCompressList<E>(src);
    }

    public static <E> E getOrDefault(List<E> elements, int index, E def) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index);
        }
        if (elements == null || index >= elements.size()) {
            return def;
        }
        return elements.get(index);
    }

    public static <E> E firstOrDefault(List<E> elements, E def) {
        if (elements == null || elements.isEmpty()) {
            return def;
        }
        return elements.getFirst();
    }

    public static <E> E lastOrDefault(List<E> elements, E def) {
        if (elements == null || elements.isEmpty()) {
            return def;
        }
        return elements.getLast();
    }

    public static void removeFirstN(List<?> list, int n) {
        if (n <= 0) {
            return;
        }
        if (list.size() <= n) {
            list.clear();
        } else {
            list.subList(0, n).clear();
        }
    }

    public static void removeLastN(List<?> list, int n) {
        if (n <= 0) {
            return;
        }
        if (list.size() <= n) {
            list.clear();
        } else {
            list.subList(list.size() - n, list.size()).clear();
        }
    }

    public static <E> boolean removeFirstMatch(List<E> list, Predicate<? super E> predicate) {
        if (list.isEmpty()) {
            return false;
        }
        int index = CollectionUtils.indexOfCustom(list, predicate);
        if (index >= 0) {
            list.remove(index);
            return true;
        }
        return false;
    }

    public static <E> boolean removeLastMatch(List<E> list, Predicate<? super E> predicate) {
        if (list.isEmpty()) {
            return false;
        }
        int index = CollectionUtils.lastIndexOfCustom(list, predicate);
        if (index >= 0) {
            list.remove(index);
            return true;
        }
        return false;
    }

    public static <E> E removeAt(List<E> list, int index, boolean ordered) {
        if (ordered) {
            return list.remove(index);
        }
        E deleted = list.get(index);
        int tailIndex = list.size() - 1;
        if (index < tailIndex) {
            list.set(index, list.get(tailIndex));
        }
        list.remove(tailIndex);
        return deleted;
    }

    public static <E> int unorderedRemoveIf(List<E> list, Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        int originSize = list.size();
        if (originSize == 0) {
            return 0;
        }
        int size = originSize;
        int index = 0;
        while (index < size) {
            E e = list.get(index);
            if (!filter.test(e)) {
                ++index;
                continue;
            }
            if (index < --size) {
                list.set(index, list.get(size));
            }
            list.remove(size);
        }
        return originSize - size;
    }

    public static <E> int indexOfCustom(List<E> list, Predicate<? super E> indexFunc) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!indexFunc.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <E> int lastIndexOfCustom(List<E> list, Predicate<? super E> indexFunc) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!indexFunc.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <E> boolean containsCustom(List<E> list, Predicate<? super E> indexFunc) {
        return CollectionUtils.indexOfCustom(list, indexFunc) >= 0;
    }

    public static <E> E findFirst(List<E> list, Predicate<? super E> indexFunc) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            E e = list.get(i);
            if (!indexFunc.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <E> E findLast(List<E> list, Predicate<? super E> indexFunc) {
        for (int i = list.size() - 1; i >= 0; --i) {
            E e = list.get(i);
            if (!indexFunc.test(e)) continue;
            return e;
        }
        return null;
    }

    public static boolean containsRef(List<?> list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0) >= 0;
    }

    public static int indexOfRef(List<?> list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0);
    }

    public static int indexOfRef(List<?> list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex >= list.size()) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int size = list.size();
        for (int i = startIndex; i < size; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfRef(List<?> list, Object element) {
        return CollectionUtils.lastIndexOfRef(list, element, Integer.MAX_VALUE);
    }

    public static int lastIndexOfRef(List<?> list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= list.size()) {
            startIndex = list.size() - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    public static boolean removeRef(List<?> list, Object element) {
        int index = CollectionUtils.indexOfRef(list, element);
        if (index < 0) {
            return false;
        }
        list.remove(index);
        return true;
    }

    public static boolean removeRef(List<?> list, Object element, boolean ordered) {
        int index = CollectionUtils.indexOfRef(list, element);
        if (index < 0) {
            return false;
        }
        CollectionUtils.removeAt(list, index, ordered);
        return true;
    }

    public static <T> boolean containsRef(T[] list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0) >= 0;
    }

    public static <T> int indexOfRef(T[] list, Object element) {
        return CollectionUtils.indexOfRef(list, element, 0);
    }

    public static <T> int indexOfRef(T[] list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex >= list.length) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int size = list.length;
        for (int i = startIndex; i < size; ++i) {
            if (list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOfRef(T[] list, Object element) {
        return CollectionUtils.lastIndexOfRef(list, element, Integer.MAX_VALUE);
    }

    public static <T> int lastIndexOfRef(T[] list, Object element, int startIndex) {
        Objects.requireNonNull(list, "list");
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= list.length) {
            startIndex = list.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <E> ArrayList<E> newArrayList(E a) {
        ArrayList<E> result = new ArrayList<E>(1);
        result.add(a);
        return result;
    }

    public static <E> ArrayList<E> newArrayList(E a, E b) {
        ArrayList<E> result = new ArrayList<E>(2);
        result.add(a);
        result.add(b);
        return result;
    }

    public static <E> ArrayList<E> newArrayList(E a, E b, E c) {
        ArrayList<E> result = new ArrayList<E>(3);
        result.add(a);
        result.add(b);
        result.add(c);
        return result;
    }

    public static <E> boolean addAll(ArrayList<E> self, Collection<? extends E> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return self.addAll(other);
    }

    public static <E> boolean removeAll(ArrayList<E> self, Collection<? extends E> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        return self.removeAll(other);
    }

    public static <E> List<E> toList(E[] array) {
        return Arrays.asList(array);
    }

    public static <E> List<E> toList(E[] array, int offset, int length) {
        if (offset == 0 && length == array.length) {
            return Arrays.asList(array);
        }
        return Arrays.asList(array).subList(offset, offset + length);
    }

    public static <E> ArrayList<E> toArrayList(E[] array) {
        return new ArrayList<E>(new ArrayHolder<E>(array, 0, array.length));
    }

    public static <E> ArrayList<E> toArrayList(E[] array, int offset, int length) {
        return new ArrayList<E>(new ArrayHolder<E>(array, offset, length));
    }

    public static <E> List<E> union(List<E> first, List<? extends E> second) {
        int size = first.size() + second.size();
        ArrayList result = new ArrayList(size);
        CollectionUtils.addAll(result, first);
        CollectionUtils.addAll(result, second);
        return result;
    }

    @SafeVarargs
    public static <E> List<E> union(List<E> first, List<? extends E> second, List<E> ... more) {
        int size = first.size() + second.size();
        for (List<E> m : more) {
            size = Math.addExact(size, m.size());
        }
        ArrayList result = new ArrayList(size);
        CollectionUtils.addAll(result, first);
        CollectionUtils.addAll(result, second);
        for (List<E> m : more) {
            CollectionUtils.addAll(result, m);
        }
        return result;
    }

    @Nonnull
    public static <E> List<E> toImmutableList(@Nullable Collection<E> src) {
        return src == null || src.isEmpty() ? List.of() : List.copyOf(src);
    }

    @Nonnull
    public static <E> List<E> toImmutableList(@Nullable Collection<E> src, Comparator<? super E> comparator) {
        if (src == null || src.isEmpty()) {
            return List.of();
        }
        Object[] elements = src.toArray();
        Arrays.sort(elements, comparator);
        return List.of(elements);
    }

    public static <E> List<E> nullToArrayList(@Nullable List<E> src) {
        return src == null ? new ArrayList() : src;
    }

    public static <E> List<E> nullToEmptyList(@Nullable List<E> src) {
        return src == null ? List.of() : src;
    }

    public static <E> HashSet<E> newHashSet(int size) {
        return new HashSet(CollectionUtils.capacity(size));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(int size) {
        return new LinkedHashSet(CollectionUtils.capacity(size));
    }

    public static <E> Set<E> newIdentityHashSet(int size) {
        return Collections.newSetFromMap(new IdentityHashMap(size));
    }

    @Nonnull
    public static <E> Set<E> toImmutableSet(@Nullable Collection<E> src) {
        if (src == null || src.isEmpty()) {
            return Set.of();
        }
        if (src instanceof EnumSet) {
            EnumSet enumSet = (EnumSet)src;
            return Collections.unmodifiableSet(enumSet.clone());
        }
        if (src.getClass() == HashSet.class) {
            return Set.of(src.toArray());
        }
        return Set.copyOf(src);
    }

    public static <E> Set<E> toImmutableLinkedHashSet(@Nullable Collection<E> src) {
        if (src == null || src.isEmpty()) {
            return Set.of();
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(src));
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(CollectionUtils.capacity(size));
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>(4);
        map.put(k, v);
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(K k, V v, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>(4);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int size) {
        return new LinkedHashMap(CollectionUtils.capacity(size));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K k, V v) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(4);
        map.put(k, v);
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(K k, V v, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(4);
        map.put(k, v);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int size) {
        return new IdentityHashMap(size);
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key) {
        V v = map.get(key);
        if (v == null && !map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("key is absent, key %s", key));
        }
        return v;
    }

    public static <K, V> V getOrThrow(Map<K, V> map, K key, String property) {
        V v = map.get(key);
        if (v == null && !map.containsKey(key)) {
            throw new IllegalArgumentException(String.format("%s is absent, key %s", ObjectUtils.nullToDef(property, "key"), key));
        }
        return v;
    }

    public static <K> K firstKey(Map<K, ?> map) {
        if (map instanceof SequencedMap) {
            SequencedMap sequencedMap = (SequencedMap)map;
            return sequencedMap.firstEntry().getKey();
        }
        return map.keySet().iterator().next();
    }

    public static <K, V> Map.Entry<K, V> firstEntry(Map<K, V> map) {
        if (map instanceof SequencedMap) {
            SequencedMap sequencedMap = (SequencedMap)map;
            return sequencedMap.firstEntry();
        }
        return map.entrySet().iterator().next();
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> src) {
        HashMap out = CollectionUtils.newHashMap(src.size());
        src.forEach((k, v) -> out.put(v, k));
        return out;
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> src, Map<V, K> out) {
        src.forEach((k, v) -> out.put(v, k));
        return out;
    }

    @Nonnull
    public static <K, V> Map<K, V> toImmutableMap(@Nullable Map<K, V> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        if (src instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)src;
            return Collections.unmodifiableMap(enumMap.clone());
        }
        return Map.copyOf(src);
    }

    public static <K, V> Map<K, V> toImmutableLinkedHashMap(@Nullable Map<K, V> src) {
        if (src == null || src.isEmpty()) {
            return Map.of();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(src));
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static void clear(@Nullable Collection<?> collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static void clear(@Nullable Map<?, ?> map) {
        if (map != null) {
            map.clear();
        }
    }

    public static boolean joint(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        return !Collections.disjoint(source, candidates);
    }

    public static boolean disjoint(Collection<?> source, Collection<?> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return true;
        }
        return Collections.disjoint(source, candidates);
    }

    public static <E> E first(Collection<E> elements) {
        if (elements instanceof SequencedCollection) {
            SequencedCollection sequenced = (SequencedCollection)elements;
            return sequenced.getFirst();
        }
        return elements.iterator().next();
    }

    @Nullable
    public static <E> E firstOrDefault(Collection<E> collection, E def) {
        if (collection == null || collection.isEmpty()) {
            return def;
        }
        if (collection instanceof SequencedCollection) {
            SequencedCollection sequenced = (SequencedCollection)collection;
            return sequenced.getFirst();
        }
        return collection.iterator().next();
    }

    public static <E> boolean removeFirstMatch(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof RandomAccess) {
            List list = (List)collection;
            return CollectionUtils.removeFirstMatch(list, predicate);
        }
        Iterator<E> itr = collection.iterator();
        while (itr.hasNext()) {
            if (!predicate.test(itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static boolean removeRef(Collection<?> collection, Object element) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof RandomAccess) {
            List list = (List)collection;
            return CollectionUtils.removeRef(list, element);
        }
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e != element) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public static <T> Stream<T> streamOf(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> streamOf(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static int capacity(int numMappings) {
        Preconditions.checkNonNegative(numMappings, "numMappings");
        if (numMappings < 3) {
            return 4;
        }
        return (int)Math.ceil((double)numMappings / 0.75);
    }

    private static class ArrayHolder<E>
    extends AbstractCollection<E> {
        final E[] array;
        final int offset;
        final int length;

        private ArrayHolder(E[] array, int offset, int length) {
            this.array = Objects.requireNonNull(array);
            this.offset = offset;
            this.length = length;
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            if (this.offset == 0 && this.length == this.array.length) {
                return this.array;
            }
            Object[] dest = new Object[this.length];
            System.arraycopy(this.array, this.offset, dest, 0, this.length);
            return dest;
        }

        @Override
        @Nonnull
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

