/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

public interface Constant<T extends Constant<T>>
extends Comparable<T> {
    public int id();

    public String name();

    public static String checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is empty ");
        }
        return name;
    }

    public static abstract class Builder<T> {
        private Integer id;
        private final String name;

        public Builder(String name) {
            this.name = Constant.checkName(name);
        }

        public Builder<T> setId(int id) {
            if (this.id != null) {
                throw new IllegalStateException("id cannot be initialized repeatedly");
            }
            this.id = id;
            return this;
        }

        public int getIdOrThrow() {
            if (this.id == null) {
                throw new IllegalStateException("id has not been initialized");
            }
            return this.id;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public abstract T build();
    }
}

