/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.StringBuilderPool;
import cn.wjybxx.base.pool.ObjectPool;
import javax.annotation.Nonnull;

public class LocalStringBuilderPool
implements ObjectPool<StringBuilder> {
    public static final LocalStringBuilderPool INSTANCE = new LocalStringBuilderPool();
    private static final int POOL_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.PoolSize", 8);
    private static final int INIT_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.InitCapacity", 1024);
    private static final int MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.MaxCapacity", 65536);
    private static final ThreadLocal<StringBuilderPool> THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new StringBuilderPool(POOL_SIZE, INIT_CAPACITY, MAX_CAPACITY));

    @Override
    @Nonnull
    public StringBuilder rent() {
        return THREAD_LOCAL_INST.get().rent();
    }

    @Override
    public void returnOne(StringBuilder builder) {
        THREAD_LOCAL_INST.get().returnOne(builder);
    }

    @Override
    public void freeAll() {
    }

    public StringBuilderPool localInst() {
        return THREAD_LOCAL_INST.get();
    }
}

