/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import java.util.Arrays;
import java.util.Objects;

public class ObjectUtils {
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    public static <V> V nullToDef(V obj, V def) {
        return obj == null ? def : obj;
    }

    public static int hashCode(Object first) {
        return Objects.hashCode(first);
    }

    public static int hashCode(Object first, Object second) {
        int result = Objects.hashCode(first);
        result = 31 * result + Objects.hashCode(second);
        return result;
    }

    public static int hashCode(Object first, Object second, Object third) {
        int result = Objects.hashCode(first);
        result = 31 * result + Objects.hashCode(second);
        result = 31 * result + Objects.hashCode(third);
        return result;
    }

    public static int hashCode(Object ... args) {
        return Arrays.hashCode(args);
    }

    public static String toString(Object object, String nullDef) {
        return object == null ? nullDef : object.toString();
    }

    public static String toStringIfNotNull(Object object) {
        return object == null ? null : object.toString();
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = ObjectUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String string) {
        return string == null || string.isBlank();
    }

    public static <T extends CharSequence> T emptyToDef(T str, T def) {
        return ObjectUtils.isEmpty(str) ? def : str;
    }

    public static <T extends CharSequence> T blankToDef(T str, T def) {
        return ObjectUtils.isBlank(str) ? def : str;
    }

    public static String emptyToDef(String str, String def) {
        return ObjectUtils.isEmpty(str) ? def : str;
    }

    public static String blankToDef(String str, String def) {
        return ObjectUtils.isBlank(str) ? def : str;
    }

    public static char lastChar(CharSequence value) {
        return value.charAt(value.length() - 1);
    }

    public static String firstCharToUpperCase(String str) {
        int length = ObjectUtils.length(str);
        if (length == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toUpperCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    public static String firstCharToLowerCase(String str) {
        int length = ObjectUtils.length(str);
        if (length == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isUpperCase(firstChar)) {
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toLowerCase(firstChar));
            return sb.toString();
        }
        return str;
    }

    public static boolean containsWhitespace(CharSequence cs) {
        int strLen = ObjectUtils.length(cs);
        if (strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(cs.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChecked(Throwable throwable) {
        return !(throwable instanceof Error) && !(throwable instanceof RuntimeException);
    }

    public static boolean isUnchecked(Throwable throwable) {
        return throwable instanceof Error || throwable instanceof RuntimeException;
    }

    public static <R> R rethrow(Throwable throwable) {
        return ObjectUtils.throwAsUncheckedException(throwable);
    }

    public static <T extends Throwable> T throwUnchecked(T throwable) {
        if (ObjectUtils.isUnchecked(throwable)) {
            return (T)((Throwable)ObjectUtils.throwAsUncheckedException(throwable));
        }
        return throwable;
    }

    private static <R, T extends Throwable> R throwAsUncheckedException(Throwable throwable) throws T {
        throw throwable;
    }

    public static <T> T defaultValue(Class<T> type) {
        Objects.requireNonNull(type);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Float.TYPE) {
                return (T)FLOAT_DEFAULT;
            }
            if (type == Double.TYPE) {
                return (T)DOUBLE_DEFAULT;
            }
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            throw new IllegalArgumentException("void");
        }
        return null;
    }
}

