/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base;

import cn.wjybxx.base.EnumLite;
import java.util.NoSuchElementException;

public enum OptionalBool implements EnumLite
{
    FALSE(false),
    TRUE(true),
    EMPTY(false);

    private final boolean value;

    private OptionalBool(boolean v) {
        this.value = v;
    }

    public static OptionalBool valueOf(Boolean value) {
        if (value == null) {
            return EMPTY;
        }
        return value != false ? TRUE : FALSE;
    }

    public static OptionalBool valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public Boolean toBoxBool() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Boolean.FALSE;
            case 1 -> Boolean.TRUE;
            case 2 -> null;
        };
    }

    public boolean getAsBool() {
        if (this == EMPTY) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public boolean orElse(boolean value) {
        return this == EMPTY ? value : this.value;
    }

    public boolean orElseThrow() {
        if (this == EMPTY) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public String toString() {
        return "OptionalBool." + this.name();
    }

    @Override
    public int getNumber() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
        };
    }

    public static OptionalBool forNumber(int number) {
        return switch (number) {
            case 0 -> FALSE;
            case 1 -> TRUE;
            case 2 -> EMPTY;
            default -> throw new IllegalArgumentException("invalid number " + number);
        };
    }
}

