/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.collection;

public enum DequeOverflowBehavior {
    THROW_EXCEPTION(0),
    DISCARD_HEAD(1),
    DISCARD_TAIL(2),
    CIRCLE_BUFFER(3);

    private final int number;

    private DequeOverflowBehavior(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean allowDiscardHead() {
        return this == CIRCLE_BUFFER || this == DISCARD_HEAD;
    }

    public boolean allowDiscardTail() {
        return this == CIRCLE_BUFFER || this == DISCARD_TAIL;
    }

    public static DequeOverflowBehavior forNumber(int number) {
        return switch (number) {
            case 0 -> THROW_EXCEPTION;
            case 1 -> DISCARD_HEAD;
            case 2 -> DISCARD_TAIL;
            case 3 -> CIRCLE_BUFFER;
            default -> throw new IllegalArgumentException("number: " + number);
        };
    }
}

