/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;

class ArrayPoolCore {
    private static final Consumer<Object> clear_objectArray = array -> Arrays.fill((Object[])array, null);
    private static final Consumer<Object> clear_charArray = array -> Arrays.fill((char[])array, '\u0000');
    private static final Consumer<Object> clear_intArray = array -> Arrays.fill((int[])array, 0);
    private static final Consumer<Object> clear_longArray = array -> Arrays.fill((long[])array, 0L);
    private static final Consumer<Object> clear_floatArray = array -> Arrays.fill((float[])array, 0.0f);
    private static final Consumer<Object> clear_doubleArray = array -> Arrays.fill((double[])array, 0.0);
    private static final Consumer<Object> clear_shortArray = array -> Arrays.fill((short[])array, (short)0);
    private static final Consumer<Object> clear_boolArray = array -> Arrays.fill((boolean[])array, false);
    private static final Consumer<Object> clear_byteArray = array -> Arrays.fill((byte[])array, (byte)0);
    public static final Comparator<Node<?>> COMPARATOR = (left, right) -> {
        int r = Integer.compare(left.length(), right.length());
        if (r != 0) {
            return r;
        }
        return Long.compare(left.sequence(), right.sequence());
    };

    ArrayPoolCore() {
    }

    public static boolean isRefArray(Class<?> arrayType) {
        return !arrayType.getComponentType().isPrimitive();
    }

    public static <T> Consumer<T> findClearHandler(Class<T> arrayType) {
        Class<?> componentType = arrayType.getComponentType();
        if (!componentType.isPrimitive()) {
            return clear_objectArray;
        }
        if (componentType == Byte.TYPE) {
            return clear_byteArray;
        }
        if (componentType == Character.TYPE) {
            return clear_charArray;
        }
        if (componentType == Integer.TYPE) {
            return clear_intArray;
        }
        if (componentType == Long.TYPE) {
            return clear_longArray;
        }
        if (componentType == Float.TYPE) {
            return clear_floatArray;
        }
        if (componentType == Double.TYPE) {
            return clear_doubleArray;
        }
        if (componentType == Short.TYPE) {
            return clear_shortArray;
        }
        if (componentType == Boolean.TYPE) {
            return clear_boolArray;
        }
        throw new IllegalArgumentException("Unsupported arrayType: " + arrayType.getSimpleName());
    }

    static interface Node<T> {
        public T array();

        public int length();

        public long sequence();
    }

    public static class LengthNode<T>
    implements Node<T> {
        final int length;

        public LengthNode(int length) {
            this.length = length;
        }

        @Override
        public T array() {
            throw new IllegalStateException();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public long sequence() {
            return 0L;
        }
    }

    public static class ArrayNode<T>
    implements Node<T> {
        final T array;
        final int length;
        final long sequence;

        public ArrayNode(T array, int length, long sequence) {
            this.array = array;
            this.length = length;
            this.sequence = sequence;
        }

        @Override
        public T array() {
            return this.array;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public long sequence() {
            return this.sequence;
        }
    }
}

