/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.ArrayPool;
import cn.wjybxx.base.io.SimpleArrayPool;

public class LocalCharArrayPool
implements ArrayPool<char[]> {
    public static final LocalCharArrayPool INSTANCE = new LocalCharArrayPool();
    private static final int POOL_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalCharArrayPool.PoolSize", 4);
    private static final int INIT_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalCharArrayPool.InitCapacity", 1024);
    private static final int MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalCharArrayPool.MaxCapacity", 65536);
    private static final ThreadLocal<SimpleArrayPool<char[]>> THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new SimpleArrayPool<char[]>(char[].class, POOL_SIZE, INIT_CAPACITY, MAX_CAPACITY));

    @Override
    public char[] acquire() {
        return THREAD_LOCAL_INST.get().acquire();
    }

    @Override
    public char[] acquire(int minimumLength) {
        return THREAD_LOCAL_INST.get().acquire(minimumLength);
    }

    @Override
    public char[] acquire(int minimumLength, boolean clear) {
        return THREAD_LOCAL_INST.get().acquire(minimumLength, clear);
    }

    @Override
    public void release(char[] array) {
        THREAD_LOCAL_INST.get().release(array);
    }

    @Override
    public void release(char[] array, boolean clear) {
        THREAD_LOCAL_INST.get().release(array, clear);
    }

    @Override
    public void clear() {
    }

    public SimpleArrayPool<char[]> localInst() {
        return THREAD_LOCAL_INST.get();
    }
}

