/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.base.io;

import cn.wjybxx.base.SystemPropsUtils;
import cn.wjybxx.base.io.StringBuilderPool;
import cn.wjybxx.base.pool.ObjectPool;
import javax.annotation.Nonnull;

public class LocalStringBuilderPool
implements ObjectPool<StringBuilder> {
    public static final LocalStringBuilderPool INSTANCE = new LocalStringBuilderPool();
    private static final int POOL_SIZE = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.PoolSize", 8);
    private static final int INIT_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.InitCapacity", 1024);
    private static final int MAX_CAPACITY = SystemPropsUtils.getInt("Wjybxx.Commons.IO.LocalStringBuilderPool.MaxCapacity", 65536);
    private static final ThreadLocal<StringBuilderPool> THREAD_LOCAL_INST = ThreadLocal.withInitial(() -> new StringBuilderPool(POOL_SIZE, INIT_CAPACITY, MAX_CAPACITY));

    @Override
    @Nonnull
    public StringBuilder acquire() {
        return THREAD_LOCAL_INST.get().acquire();
    }

    @Override
    public void release(StringBuilder builder) {
        THREAD_LOCAL_INST.get().release(builder);
    }

    @Override
    public void clear() {
    }

    public StringBuilderPool localInst() {
        return THREAD_LOCAL_INST.get();
    }
}

